/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes.compiler;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class AttributeIndexer
extends Task {
    private File jarFile;
    private List classes = new ArrayList();
    private Path classPath;
    private File baseName;
    private boolean inMaven = false;
    private static final String INDEX_FILENAME = "META-INF/attrs.index";
    private static final String SUFFIX = "$__attributeRepository.class";

    public void setJarfile(File file) {
        this.jarFile = file;
    }

    public void setBaseName(File file) {
        this.inMaven = true;
        this.baseName = file;
    }

    public Path createClasspath() {
        this.classPath = new Path(((ProjectComponent)this).project);
        return this.classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyEntry(JarFile jarFile, JarEntry jarEntry, JarOutputStream jarOutputStream) throws Exception {
        jarOutputStream.putNextEntry(jarEntry);
        if (!jarEntry.isDirectory()) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
            try {
                int n;
                byte[] byArray = new byte[16384];
                while ((n = ((InputStream)bufferedInputStream).read(byArray, 0, 16384)) != 0 && n != -1) {
                    jarOutputStream.write(byArray, 0, n);
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                ((InputStream)bufferedInputStream).close();
                throw throwable;
            }
            ((InputStream)bufferedInputStream).close();
            {
            }
        }
    }

    protected void findJarFile() throws BuildException {
        File[] fileArray = this.baseName.getParentFile().listFiles();
        if (fileArray == null) {
            throw new BuildException("Unable to find any file with base name " + this.baseName.getName() + " in " + this.baseName.getParentFile().getPath());
        }
        long l = 0L;
        int n = 0;
        while (n < fileArray.length) {
            String string = fileArray[n].getName();
            if (string.startsWith(this.baseName.getName()) && string.endsWith(".jar") && fileArray[n].lastModified() > l) {
                this.jarFile = fileArray[n];
                l = fileArray[n].lastModified();
            }
            ++n;
        }
        if (this.jarFile == null) {
            throw new BuildException("Unable to find any file with base name " + this.baseName.getName() + " in " + this.baseName.getParentFile().getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.inMaven) {
            this.findJarFile();
        }
        if (!this.jarFile.exists()) {
            this.log("Can't find " + this.jarFile.getPath());
            return;
        }
        try {
            this.log("Creating attribute index for " + this.jarFile.getPath());
            JarFile jarFile = new JarFile(this.jarFile);
            File file = new File(this.jarFile.getPath() + ".new");
            JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file));
            try {
                String string;
                Object object;
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (!((ZipEntry)object).isDirectory() && (string = ((ZipEntry)object).getName()).endsWith(SUFFIX)) {
                        string = string.replace('/', '.').replace('\\', '.').substring(0, string.length() - SUFFIX.length());
                        this.classes.add(string);
                    }
                    if (((ZipEntry)object).getName().equals(INDEX_FILENAME)) continue;
                    this.copyEntry(jarFile, (JarEntry)object, jarOutputStream);
                }
                jarOutputStream.putNextEntry(new JarEntry(INDEX_FILENAME));
                object = this.classes.iterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    jarOutputStream.write(("Class: " + string + "\n").getBytes());
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                jarOutputStream.close();
                jarFile.close();
                throw throwable;
            }
            jarOutputStream.close();
            jarFile.close();
            this.jarFile.delete();
            file.renameTo(this.jarFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BuildException(exception.toString());
        }
    }

    static {
        INDEX_FILENAME = INDEX_FILENAME;
        SUFFIX = SUFFIX;
    }
}

