/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.attributes.compiler.AttributeExpressionParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import xjavadoc.SourceClass;
import xjavadoc.XClass;
import xjavadoc.XConstructor;
import xjavadoc.XField;
import xjavadoc.XJavaDoc;
import xjavadoc.XMethod;
import xjavadoc.XParameter;
import xjavadoc.XProgramElement;
import xjavadoc.XTag;
import xjavadoc.ant.XJavadocTask;
import xjavadoc.filesystem.AbstractFile;

public class AttributeCompiler
extends XJavadocTask {
    private final ArrayList fileSets = new ArrayList();
    private Path src;
    private File destDir;
    private int numGenerated;
    private int numIgnored;
    private String attributePackages = "";

    public void setAttributePackages(String string) {
        this.attributePackages = string;
    }

    public void addFileset(FileSet fileSet) {
        super.addFileset(fileSet);
        this.fileSets.add(fileSet);
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setSourcepathref(String string) {
        String string2 = ((ProjectComponent)this).project.getReference(string).toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            FileSet fileSet = new FileSet();
            fileSet.setDir(new File(stringTokenizer.nextToken()));
            fileSet.setIncludes("**/*.java");
            fileSet.setProject(((ProjectComponent)this).project);
            this.addFileset(fileSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyImports(File file, PrintWriter printWriter) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith("import ")) continue;
                printWriter.println(string);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
    }

    protected void addExpressions(Collection collection, PrintWriter printWriter, String string, File file) {
        this.addExpressions(collection, null, printWriter, string, file);
    }

    protected void addExpressions(Collection collection, String string, PrintWriter printWriter, String string2, File file) {
        String string3 = file != null ? file.getPath().replace('\\', '/') : "<unknown>";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            XTag xTag = (XTag)iterator.next();
            if (!this.isAttribute(xTag)) continue;
            String string4 = xTag.getName() + " " + xTag.getValue();
            string4 = string4.trim();
            string4 = string4.substring(1);
            if (string != null) {
                if (!string4.startsWith(".")) continue;
                String string5 = string4.substring(1, string4.indexOf(" "));
                string4 = string4.substring(string4.indexOf(" ")).trim();
                if (!string.equals(string5)) {
                    continue;
                }
            } else if (string4.startsWith(".")) continue;
            printWriter.println("        {");
            this.outputAttributeExpression(printWriter, string4, string3, xTag.getLineNumber(), "_attr");
            printWriter.println("        Object _oattr = _attr; // Need to erase type information");
            printWriter.println("        if (_oattr instanceof org.apache.commons.attributes.Sealable) {");
            printWriter.println("            ((org.apache.commons.attributes.Sealable) _oattr).seal ();");
            printWriter.println("        }");
            printWriter.println("        " + string2 + ".add ( _attr );");
            printWriter.println("        }");
        }
    }

    protected void outputAttributeExpression(PrintWriter printWriter, String string, String string2, int n, String string3) {
        AttributeExpressionParser.Argument argument;
        AttributeExpressionParser.ParseResult parseResult = AttributeExpressionParser.parse(string, string2, n);
        printWriter.print("            " + parseResult.className + " " + string3 + " = new " + parseResult.className + "(");
        boolean bl = true;
        Iterator iterator = parseResult.arguments.iterator();
        while (iterator.hasNext()) {
            argument = (AttributeExpressionParser.Argument)iterator.next();
            if (argument.field != null) continue;
            if (!bl) {
                printWriter.print(", ");
            }
            bl = false;
            printWriter.print(argument.text);
        }
        printWriter.println("  // " + string2 + ":" + n);
        printWriter.println(");");
        iterator = parseResult.arguments.iterator();
        while (iterator.hasNext()) {
            argument = (AttributeExpressionParser.Argument)iterator.next();
            if (argument.field == null) continue;
            String string4 = "set" + argument.field.substring(0, 1).toUpperCase() + argument.field.substring(1);
            printWriter.println("            " + string3 + "." + string4 + "(\n" + argument.text + "  // " + string2 + ":" + n + "\n" + ");");
        }
    }

    protected boolean elementHasAttributes(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            XProgramElement xProgramElement = (XProgramElement)iterator.next();
            if (!this.tagHasAttributes(xProgramElement.getDoc().getTags())) continue;
            return true;
        }
        return false;
    }

    private void getTransformedQualifiedName(XClass xClass, StringBuffer stringBuffer) {
        if (xClass.isInner()) {
            String string = xClass.getContainingPackage().getName();
            stringBuffer.append(string);
            if (string.length() > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(xClass.getName().replace('.', '$'));
        } else {
            stringBuffer.append(xClass.getQualifiedName());
        }
    }

    protected String getParameterTypes(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            XParameter xParameter = (XParameter)iterator.next();
            this.getTransformedQualifiedName(xParameter.getType(), stringBuffer);
            stringBuffer.append(xParameter.getDimensionAsString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    protected void generateClass(XClass xClass) throws Exception {
        String string = null;
        File file = null;
        File file2 = null;
        String string2 = null;
        String string3 = null;
        string2 = xClass.getContainingPackage().getName();
        if (xClass.isInner()) {
            string = xClass.getQualifiedName().substring(string2.length());
            file = this.getSourceFile(xClass);
            string3 = xClass.getName().replace('.', '$');
            string = string2 + (string2.length() > 0 ? "." : "") + string3;
        } else {
            string = xClass.getQualifiedName();
            file = this.getSourceFile(xClass);
            string3 = xClass.getName();
        }
        if (file == null) {
            this.log("Unable to find source file for: " + string);
        }
        file2 = new File(this.destDir, string.replace('.', '/') + "$__attributeRepository.java");
        if (xClass.isAnonymous()) {
            this.log(xClass.getName() + " is anonymous - ignoring.", 3);
            ++this.numIgnored;
            return;
        }
        if (!this.hasAttributes(xClass)) {
            if (file2.exists()) {
                file2.delete();
            }
            return;
        }
        if (file2.exists() && file != null && file2.lastModified() >= file.lastModified()) {
            return;
        }
        ++this.numGenerated;
        file2.getParentFile().mkdirs();
        PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
        try {
            XParameter xParameter;
            Object object;
            CharSequence charSequence;
            StringBuffer stringBuffer;
            Object object2;
            Object object3;
            if (string2 != null && !string2.equals("")) {
                printWriter.println("package " + string2 + ";");
            }
            if (file != null) {
                this.copyImports(file, printWriter);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.attributePackages, ";");
            while (stringTokenizer.hasMoreTokens()) {
                printWriter.println("import " + stringTokenizer.nextToken() + ".*;");
            }
            printWriter.println("public class " + string3 + "$__attributeRepository implements org.apache.commons.attributes.AttributeRepositoryClass {");
            printWriter.println("    private final java.util.Set classAttributes = new java.util.HashSet ();");
            printWriter.println("    private final java.util.Map fieldAttributes = new java.util.HashMap ();");
            printWriter.println("    private final java.util.Map methodAttributes = new java.util.HashMap ();");
            printWriter.println("    private final java.util.Map constructorAttributes = new java.util.HashMap ();");
            printWriter.println();
            printWriter.println("    public " + string3 + "$__attributeRepository " + "() {");
            printWriter.println("        initClassAttributes ();");
            printWriter.println("        initMethodAttributes ();");
            printWriter.println("        initFieldAttributes ();");
            printWriter.println("        initConstructorAttributes ();");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("    public java.util.Set getClassAttributes () { return classAttributes; }");
            printWriter.println("    public java.util.Map getFieldAttributes () { return fieldAttributes; }");
            printWriter.println("    public java.util.Map getConstructorAttributes () { return constructorAttributes; }");
            printWriter.println("    public java.util.Map getMethodAttributes () { return methodAttributes; }");
            printWriter.println();
            printWriter.println("    private void initClassAttributes () {");
            this.addExpressions(xClass.getDoc().getTags(), printWriter, "classAttributes", file);
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("    private void initFieldAttributes () {");
            printWriter.println("        java.util.Set attrs = null;");
            Iterator iterator = xClass.getFields().iterator();
            while (iterator.hasNext()) {
                object3 = (XField)iterator.next();
                if (object3.getDoc().getTags().size() <= 0) continue;
                object2 = object3.getName();
                printWriter.println("        attrs = new java.util.HashSet ();");
                this.addExpressions(object3.getDoc().getTags(), printWriter, "attrs", file);
                printWriter.println("        fieldAttributes.put (\"" + (String)object2 + "\", attrs);");
                printWriter.println("        attrs = null;");
                printWriter.println();
            }
            printWriter.println("    }");
            printWriter.println("    private void initMethodAttributes () {");
            printWriter.println("        java.util.Set attrs = null;");
            printWriter.println("        java.util.List bundle = null;");
            object3 = xClass.getMethods().iterator();
            while (object3.hasNext()) {
                object2 = (XMethod)object3.next();
                if (object2.getDoc().getTags().size() <= 0) continue;
                stringBuffer = new StringBuffer();
                stringBuffer.append(object2.getName()).append("(");
                stringBuffer.append(this.getParameterTypes(object2.getParameters()));
                stringBuffer.append(")");
                charSequence = stringBuffer.toString();
                printWriter.println("        bundle = new java.util.ArrayList ();");
                printWriter.println("        attrs = new java.util.HashSet ();");
                this.addExpressions(object2.getDoc().getTags(), null, printWriter, "attrs", file);
                printWriter.println("        bundle.add (attrs);");
                printWriter.println("        attrs = null;");
                printWriter.println("        attrs = new java.util.HashSet ();");
                this.addExpressions(object2.getDoc().getTags(), "return", printWriter, "attrs", file);
                printWriter.println("        bundle.add (attrs);");
                printWriter.println("        attrs = null;");
                object = object2.getParameters().iterator();
                while (object.hasNext()) {
                    xParameter = (XParameter)object.next();
                    printWriter.println("        attrs = new java.util.HashSet ();");
                    this.addExpressions(object2.getDoc().getTags(), xParameter.getName(), printWriter, "attrs", file);
                    printWriter.println("        bundle.add (attrs);");
                    printWriter.println("        attrs = null;");
                }
                printWriter.println("        methodAttributes.put (\"" + (String)charSequence + "\", bundle);");
                printWriter.println("        bundle = null;");
                printWriter.println();
            }
            printWriter.println("    }");
            printWriter.println("    private void initConstructorAttributes () {");
            printWriter.println("        java.util.Set attrs = null;");
            printWriter.println("        java.util.List bundle = null;");
            object2 = xClass.getConstructors().iterator();
            while (object2.hasNext()) {
                stringBuffer = (XConstructor)object2.next();
                if (stringBuffer.getDoc().getTags().size() <= 0) continue;
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("(");
                ((StringBuffer)charSequence).append(this.getParameterTypes(stringBuffer.getParameters()));
                ((StringBuffer)charSequence).append(")");
                object = ((StringBuffer)charSequence).toString();
                printWriter.println("        bundle = new java.util.ArrayList ();");
                printWriter.println("        attrs = new java.util.HashSet ();");
                this.addExpressions(stringBuffer.getDoc().getTags(), null, printWriter, "attrs", file);
                printWriter.println("        bundle.add (attrs);");
                printWriter.println("        attrs = null;");
                xParameter = stringBuffer.getParameters().iterator();
                while (xParameter.hasNext()) {
                    XParameter xParameter2 = (XParameter)xParameter.next();
                    printWriter.println("        attrs = new java.util.HashSet ();");
                    this.addExpressions(stringBuffer.getDoc().getTags(), xParameter2.getName(), printWriter, "attrs", file);
                    printWriter.println("        bundle.add (attrs);");
                    printWriter.println("        attrs = null;");
                }
                printWriter.println("        constructorAttributes.put (\"" + (String)object + "\", bundle);");
                printWriter.println("        bundle = null;");
                printWriter.println();
            }
            printWriter.println("    }");
            printWriter.println("}");
            printWriter.close();
        }
        catch (Exception exception) {
            printWriter.close();
            file2.delete();
            throw exception;
        }
    }

    protected File getSourceFile(XClass xClass) throws BuildException {
        while (xClass != null && xClass.isInner()) {
            xClass = xClass.getContainingClass();
        }
        if (xClass != null && xClass instanceof SourceClass) {
            AbstractFile abstractFile = ((SourceClass)xClass).getFile();
            return new File(abstractFile.getPath());
        }
        return null;
    }

    protected boolean hasAttributes(XClass xClass) {
        return this.tagHasAttributes(xClass.getDoc().getTags()) || this.elementHasAttributes(xClass.getFields()) || this.elementHasAttributes(xClass.getMethods()) || this.elementHasAttributes(xClass.getConstructors());
    }

    protected boolean isAttribute(XTag xTag) {
        return xTag.getName().length() > 0 && xTag.getName().charAt(0) == '@';
    }

    protected void start() throws BuildException {
        this.destDir.mkdirs();
        this.numGenerated = 0;
        XJavaDoc xJavaDoc = this.getXJavaDoc();
        Iterator iterator = xJavaDoc.getSourceClasses().iterator();
        try {
            while (iterator.hasNext()) {
                XClass xClass = (XClass)iterator.next();
                this.generateClass(xClass);
            }
        }
        catch (Exception exception) {
            throw new BuildException(exception.toString(), (Throwable)exception);
        }
        this.log("Generated attribute information for " + this.numGenerated + " classes. Ignored " + this.numIgnored + " classes.");
    }

    protected boolean tagHasAttributes(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            XTag xTag = (XTag)iterator.next();
            if (!this.isAttribute(xTag)) continue;
            return true;
        }
        return false;
    }
}

