/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.OutputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hibernate.util.DTDEntityResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public final class XMLHelper {
    private static final Log log = LogFactory.getLog((Class)XMLHelper.class);
    public static final EntityResolver DEFAULT_DTD_RESOLVER = new DTDEntityResolver();
    private DOMReader domReader;
    private SAXReader saxReader;

    public SAXReader createSAXReader(String string, List list, EntityResolver entityResolver) {
        if (this.saxReader == null) {
            this.saxReader = new SAXReader();
        }
        this.saxReader.setEntityResolver(entityResolver);
        this.saxReader.setErrorHandler((ErrorHandler)new ErrorLogger(string, list));
        this.saxReader.setMergeAdjacentText(true);
        this.saxReader.setValidation(true);
        return this.saxReader;
    }

    public DOMReader createDOMReader() {
        if (this.domReader == null) {
            this.domReader = new DOMReader();
        }
        return this.domReader;
    }

    public static Element generateDom4jElement(String string) {
        return DocumentFactory.getInstance().createElement(string);
    }

    public static void dump(Element element) {
        try {
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            XMLWriter xMLWriter = new XMLWriter((OutputStream)System.out, outputFormat);
            xMLWriter.write(element);
            xMLWriter.flush();
            System.out.println("");
        }
        catch (Throwable throwable) {
            System.out.println(element.asXML());
        }
    }

    public static class ErrorLogger
    implements ErrorHandler {
        private String file;
        private List errors;

        ErrorLogger(String string, List list) {
            this.file = string;
            this.errors = list;
        }

        public void error(SAXParseException sAXParseException) {
            log.error((Object)("Error parsing XML: " + this.file + '(' + sAXParseException.getLineNumber() + ") " + sAXParseException.getMessage()));
            this.errors.add(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) {
            this.error(sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) {
            log.warn((Object)("Warning parsing XML: " + this.file + '(' + sAXParseException.getLineNumber() + ") " + sAXParseException.getMessage()));
        }
    }
}

