/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.hibernate.util.ArrayHelper;

public final class StringHelper {
    private static final int ALIAS_TRUNCATE_LENGTH = 10;
    public static final String WHITESPACE = " \n\r\f\t";

    private StringHelper() {
    }

    public static int lastIndexOfLetter(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c)) continue;
            return i - 1;
        }
        return string.length() - 1;
    }

    public static String join(String string, String[] stringArray) {
        int n = stringArray.length;
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n * stringArray[0].length()).append(stringArray[0]);
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(string).append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String join(String string, Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        if (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuffer.append(string).append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public static String[] add(String[] stringArray, String string, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray3[i] = stringArray[i] + string + stringArray2[i];
        }
        return stringArray3;
    }

    public static String repeat(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3) {
        return StringHelper.replace(string, string2, string3, false);
    }

    public static String[] replace(String[] stringArray, String string, String string2) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = StringHelper.replace(stringArray[i], string, string2);
        }
        return stringArray2;
    }

    public static String replace(String string, String string2, String string3, boolean bl) {
        int n;
        int n2 = n = string == null ? -1 : string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        boolean bl2 = !bl || n + string2.length() == string.length() || !Character.isJavaIdentifierPart(string.charAt(n + string2.length()));
        String string4 = bl2 ? string3 : string2;
        return string.substring(0, n) + string4 + StringHelper.replace(string.substring(n + string2.length()), string2, string3, bl);
    }

    public static String replaceOnce(String string, String string2, String string3) {
        int n;
        int n2 = n = string == null ? -1 : string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n) + string3 + string.substring(n + string2.length());
    }

    public static String[] split(String string, String string2) {
        return StringHelper.split(string, string2, false);
    }

    public static String[] split(String string, String string2, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string, bl);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String unqualify(String string) {
        int n = string.lastIndexOf(".");
        return n < 0 ? string : string.substring(string.lastIndexOf(".") + 1);
    }

    public static String qualifier(String string) {
        int n = string.lastIndexOf(".");
        return n < 0 ? "" : string.substring(0, n);
    }

    public static String[] suffix(String[] stringArray, String string) {
        if (string == null) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = StringHelper.suffix(stringArray[i], string);
        }
        return stringArray2;
    }

    private static String suffix(String string, String string2) {
        return string2 == null ? string : string + string2;
    }

    public static String root(String string) {
        int n = string.indexOf(".");
        return n < 0 ? string : string.substring(0, n);
    }

    public static String unroot(String string) {
        int n = string.indexOf(".");
        return n < 0 ? string : string.substring(n + 1, string.length());
    }

    public static boolean booleanValue(String string) {
        String string2 = string.trim().toLowerCase();
        return string2.equals("true") || string2.equals("t");
    }

    public static String toString(Object[] objectArray) {
        int n = objectArray.length;
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n * 12);
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(objectArray[i]).append(", ");
        }
        return stringBuffer.append(objectArray[n - 1]).toString();
    }

    public static String[] multiply(String string, Iterator iterator, Iterator iterator2) {
        String[] stringArray = new String[]{string};
        while (iterator.hasNext()) {
            stringArray = StringHelper.multiply(stringArray, (String)iterator.next(), (String[])iterator2.next());
        }
        return stringArray;
    }

    private static String[] multiply(String[] stringArray, String string, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray2.length * stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                stringArray3[n++] = StringHelper.replaceOnce(stringArray[j], string, stringArray2[i]);
            }
        }
        return stringArray3;
    }

    public static int countUnquoted(String string, char c) {
        if ('\'' == c) {
            throw new IllegalArgumentException("Unquoted count of quotes is invalid");
        }
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = string.length();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            if (bl) {
                if ('\'' != c2) continue;
                bl = false;
                continue;
            }
            if ('\'' == c2) {
                bl = true;
                continue;
            }
            if (c2 != c) continue;
            ++n;
        }
        return n;
    }

    public static int[] locateUnquoted(String string, char c) {
        if ('\'' == c) {
            throw new IllegalArgumentException("Unquoted count of quotes is invalid");
        }
        if (string == null) {
            return new int[0];
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(20);
        int n = string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (bl) {
                if ('\'' != c2) continue;
                bl = false;
                continue;
            }
            if ('\'' == c2) {
                bl = true;
                continue;
            }
            if (c2 != c) continue;
            arrayList.add(new Integer(i));
        }
        return ArrayHelper.toIntArray(arrayList);
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String qualify(String string, String string2) {
        if (string2 == null || string == null) {
            throw new NullPointerException();
        }
        return new StringBuffer(string.length() + string2.length() + 1).append(string).append('.').append(string2).toString();
    }

    public static String[] qualify(String string, String[] stringArray) {
        if (string == null) {
            return stringArray;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = StringHelper.qualify(string, stringArray[i]);
        }
        return stringArray2;
    }

    public static int firstIndexOfChar(String string, String string2, int n) {
        int n2 = -1;
        for (int i = 0; i < string2.length(); ++i) {
            int n3 = string.indexOf(string2.charAt(i), n);
            if (n3 < 0) continue;
            n2 = n2 == -1 ? n3 : Math.min(n2, n3);
        }
        return n2;
    }

    public static String truncate(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String generateAlias(String string) {
        return StringHelper.generateAliasRoot(string) + '_';
    }

    public static String generateAlias(String string, int n) {
        return StringHelper.generateAliasRoot(string) + Integer.toString(n) + '_';
    }

    private static String generateAliasRoot(String string) {
        String string2 = StringHelper.truncate(StringHelper.unqualifyEntityName(string), 10).toLowerCase().replace('/', '_').replace('$', '_');
        if (Character.isDigit((string2 = StringHelper.cleanAlias(string2)).charAt(string2.length() - 1))) {
            return string2 + "x";
        }
        return string2;
    }

    private static String cleanAlias(String string) {
        char[] cArray = string.toCharArray();
        if (!Character.isLetter(cArray[0])) {
            for (int i = 1; i < cArray.length; ++i) {
                if (!Character.isLetter(cArray[i])) continue;
                return string.substring(i);
            }
        }
        return string;
    }

    public static String unqualifyEntityName(String string) {
        String string2 = StringHelper.unqualify(string);
        int n = string2.indexOf(47);
        if (n > 0) {
            string2 = string2.substring(0, n - 1);
        }
        return string2;
    }

    public static String toUpperCase(String string) {
        return string == null ? null : string.toUpperCase();
    }

    public static String toLowerCase(String string) {
        return string == null ? null : string.toLowerCase();
    }

    public static String moveAndToBeginning(String string) {
        if (string.trim().length() > 0 && (string = string + " and ").startsWith(" and ")) {
            string = string.substring(4);
        }
        return string;
    }
}

