/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.collections.ReferenceMap;

public class SoftLimitMRUCache
implements Serializable {
    public static final int DEFAULT_STRONG_REF_COUNT = 128;
    private final int strongReferenceCount;
    private transient ReferenceMap softReferenceCache = new ReferenceMap(1, 1);
    private transient LRUMap strongReferenceCache;

    public SoftLimitMRUCache() {
        this(128);
    }

    public SoftLimitMRUCache(int n) {
        this.strongReferenceCount = n;
        this.init();
    }

    public synchronized Object get(Object object) {
        Object object2 = this.softReferenceCache.get(object);
        if (object2 != null) {
            this.strongReferenceCache.put(object, object2);
        }
        return object2;
    }

    public synchronized Object put(Object object, Object object2) {
        this.softReferenceCache.put(object, object2);
        return this.strongReferenceCache.put(object, object2);
    }

    public synchronized int size() {
        return this.strongReferenceCache.size();
    }

    public synchronized int softSize() {
        return this.softReferenceCache.size();
    }

    private void init() {
        this.strongReferenceCache = new LRUMap(this.strongReferenceCount);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public synchronized void clear() {
        this.strongReferenceCache.clear();
        this.softReferenceCache.clear();
    }
}

