/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.type.SerializationException;

public final class SerializationHelper {
    private static final Log log = LogFactory.getLog((Class)SerializationHelper.class);

    private SerializationHelper() {
    }

    public static Object clone(Serializable serializable) throws SerializationException {
        log.trace((Object)"Starting clone through serialization");
        return SerializationHelper.deserialize(SerializationHelper.serialize(serializable));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void serialize(Serializable serializable, OutputStream outputStream) throws SerializationException {
        if (outputStream == null) {
            throw new IllegalArgumentException("The OutputStream must not be null");
        }
        if (log.isTraceEnabled()) {
            if (Hibernate.isInitialized(serializable)) {
                log.trace((Object)("Starting serialization of object [" + serializable + "]"));
            } else {
                log.trace((Object)"Starting serialization of [uninitialized proxy]");
            }
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(serializable);
            }
            catch (IOException iOException) {
                throw new SerializationException("could not serialize", iOException);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (objectOutputStream == null) throw throwable;
                objectOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (objectOutputStream == null) return;
        objectOutputStream.close();
        return;
    }

    public static byte[] serialize(Serializable serializable) throws SerializationException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        SerializationHelper.serialize(serializable, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(InputStream inputStream) throws SerializationException {
        Object object;
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        log.trace((Object)"Starting deserialization of object");
        CustomObjectInputStream customObjectInputStream = null;
        try {
            try {
                customObjectInputStream = new CustomObjectInputStream(inputStream);
                object = customObjectInputStream.readObject();
                Object var4_5 = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SerializationException("could not deserialize", classNotFoundException);
            }
            catch (IOException iOException) {
                throw new SerializationException("could not deserialize", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                if (customObjectInputStream == null) throw throwable;
                customObjectInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return object;
        }
        if (customObjectInputStream == null) return object;
        customObjectInputStream.close();
        return object;
    }

    public static Object deserialize(byte[] byArray) throws SerializationException {
        if (byArray == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return SerializationHelper.deserialize(byteArrayInputStream);
    }

    private static final class CustomObjectInputStream
    extends ObjectInputStream {
        public CustomObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            String string = objectStreamClass.getName();
            Class<?> clazz = null;
            log.trace((Object)("Attempting to locate class [" + string + "]"));
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                clazz = classLoader.loadClass(string);
                log.trace((Object)"Class resolved through context class loader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.trace((Object)"Asking super to resolve");
                clazz = super.resolveClass(objectStreamClass);
            }
            return clazz;
        }
    }
}

