/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.property.BasicPropertyAccessor;
import org.hibernate.property.DirectPropertyAccessor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public final class ReflectHelper {
    private static final PropertyAccessor BASIC_PROPERTY_ACCESSOR;
    private static final PropertyAccessor DIRECT_PROPERTY_ACCESSOR;
    private static final Class[] NO_CLASSES;
    private static final Class[] OBJECT;
    private static final Method OBJECT_EQUALS;
    private static final Class[] NO_PARAM;
    private static final Method OBJECT_HASHCODE;

    public static boolean overridesEquals(Class clazz) {
        Method method;
        try {
            method = clazz.getMethod("equals", OBJECT);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return !OBJECT_EQUALS.equals(method);
    }

    public static boolean overridesHashCode(Class clazz) {
        Method method;
        try {
            method = clazz.getMethod("hashCode", NO_PARAM);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return !OBJECT_HASHCODE.equals(method);
    }

    public static Class reflectedPropertyClass(String string, String string2) throws MappingException {
        try {
            Class clazz = ReflectHelper.classForName(string);
            return ReflectHelper.getter(clazz, string2).getReturnType();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MappingException("class " + string + " not found while looking for property: " + string2, classNotFoundException);
        }
    }

    private static Getter getter(Class clazz, String string) throws MappingException {
        try {
            return BASIC_PROPERTY_ACCESSOR.getGetter(clazz, string);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            return DIRECT_PROPERTY_ACCESSOR.getGetter(clazz, string);
        }
    }

    public static Getter getGetter(Class clazz, String string) throws MappingException {
        return BASIC_PROPERTY_ACCESSOR.getGetter(clazz, string);
    }

    public static Class classForName(String string) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(string);
    }

    public static Class classForName(String string, Class clazz) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(string, true, clazz.getClassLoader());
    }

    public static boolean isPublic(Class clazz, Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(clazz.getModifiers());
    }

    public static Object getConstantValue(String string) {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(StringHelper.qualifier(string));
        }
        catch (Throwable throwable) {
            return null;
        }
        try {
            return clazz.getField(StringHelper.unqualify(string)).get(null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Constructor getDefaultConstructor(Class clazz) throws PropertyNotFoundException {
        if (ReflectHelper.isAbstractClass(clazz)) {
            return null;
        }
        try {
            Constructor constructor = clazz.getDeclaredConstructor(NO_CLASSES);
            if (!ReflectHelper.isPublic(clazz, constructor)) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new PropertyNotFoundException("Object class " + clazz.getName() + " must declare a default (no-argument) constructor");
        }
    }

    public static boolean isAbstractClass(Class clazz) {
        int n = clazz.getModifiers();
        return Modifier.isAbstract(n) || Modifier.isInterface(n);
    }

    public static boolean isFinalClass(Class clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static Constructor getConstructor(Class clazz, Type[] typeArray) throws PropertyNotFoundException {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Constructor<?> constructor = constructorArray[i];
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length != typeArray.length) continue;
            boolean bl = true;
            for (int j = 0; j < classArray.length; ++j) {
                boolean bl2;
                boolean bl3 = bl2 = classArray[j].isAssignableFrom(typeArray[j].getReturnedClass()) || typeArray[j] instanceof PrimitiveType && classArray[j] == ((PrimitiveType)typeArray[j]).getPrimitiveClass();
                if (bl2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            if (!ReflectHelper.isPublic(clazz, constructor)) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        throw new PropertyNotFoundException("no appropriate constructor in class: " + clazz.getName());
    }

    public static Method getMethod(Class clazz, Method method) {
        try {
            return clazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ReflectHelper() {
    }

    static {
        Method method;
        Method method2;
        BASIC_PROPERTY_ACCESSOR = new BasicPropertyAccessor();
        DIRECT_PROPERTY_ACCESSOR = new DirectPropertyAccessor();
        NO_CLASSES = new Class[0];
        OBJECT = new Class[]{Object.class};
        NO_PARAM = new Class[0];
        try {
            method2 = Object.class.getMethod("equals", OBJECT);
            method = Object.class.getMethod("hashCode", NO_PARAM);
        }
        catch (Exception exception) {
            throw new AssertionFailure("Could not find Object.equals() or Object.hashCode()", exception);
        }
        OBJECT_EQUALS = method2;
        OBJECT_HASHCODE = method;
    }
}

