/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import [Ljava.lang.String;;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.AssertionFailure;

public class NamedGeneratedKeysHelper {
    private static final Method PREPARE_STATEMENT_METHOD;
    private static final Method GET_GENERATED_KEYS_METHOD;

    private NamedGeneratedKeysHelper() {
    }

    public static PreparedStatement prepareStatement(Connection connection, String string, String[] stringArray) throws SQLException {
        Object[] objectArray = new Object[]{string, stringArray};
        try {
            return (PreparedStatement)PREPARE_STATEMENT_METHOD.invoke((Object)connection, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof SQLException) {
                throw (SQLException)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            throw new AssertionFailure("InvocationTargetException preparing statement capable of returning generated keys (JDBC3)", invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionFailure("IllegalAccessException preparing statement capable of returning generated keys (JDBC3)", illegalAccessException);
        }
    }

    public static ResultSet getGeneratedKey(PreparedStatement preparedStatement) throws SQLException {
        try {
            return (ResultSet)GET_GENERATED_KEYS_METHOD.invoke((Object)preparedStatement, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof SQLException) {
                throw (SQLException)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            throw new AssertionFailure("InvocationTargetException extracting generated keys (JDBC3)", invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionFailure("IllegalAccessException extracting generated keys (JDBC3)", illegalAccessException);
        }
    }

    static {
        try {
            PREPARE_STATEMENT_METHOD = Connection.class.getMethod("prepareStatement", String.class, String;.class);
            GET_GENERATED_KEYS_METHOD = Statement.class.getDeclaredMethod("getGeneratedKeys", null);
        }
        catch (Exception exception) {
            throw new AssertionFailure("could not initialize getGeneratedKeys() support", exception);
        }
    }
}

