/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;

public final class LinkedHashCollectionHelper {
    private static final Class SET_CLASS;
    private static final Class MAP_CLASS;
    private static final Class[] CAPACITY_CTOR_SIG;
    private static final Constructor SET_CAPACITY_CTOR;
    private static final Constructor MAP_CAPACITY_CTOR;
    private static final float LOAD_FACTOR_V = 0.75f;
    private static final Float LOAD_FACTOR;

    public static Set createLinkedHashSet() {
        try {
            return (Set)SET_CLASS.newInstance();
        }
        catch (Exception exception) {
            throw new AssertionFailure("Could not instantiate LinkedHashSet", exception);
        }
    }

    public static Set createLinkedHashSet(int n) {
        if (n <= 0) {
            return LinkedHashCollectionHelper.createLinkedHashSet();
        }
        int n2 = n + (int)((float)n * 0.75f);
        try {
            return (Set)SET_CAPACITY_CTOR.newInstance(new Integer(n2), LOAD_FACTOR);
        }
        catch (Exception exception) {
            throw new AssertionFailure("Could not instantiate LinkedHashSet", exception);
        }
    }

    public static Map createLinkedHashMap() {
        try {
            return (Map)MAP_CLASS.newInstance();
        }
        catch (Exception exception) {
            throw new AssertionFailure("Could not instantiate LinkedHashMap", exception);
        }
    }

    public static Map createLinkedHashMap(int n) {
        if (n <= 0) {
            return LinkedHashCollectionHelper.createLinkedHashMap();
        }
        int n2 = n + (int)((float)n * 0.75f);
        try {
            return (Map)MAP_CAPACITY_CTOR.newInstance(new Integer(n2), LOAD_FACTOR);
        }
        catch (Exception exception) {
            throw new AssertionFailure("Could not instantiate LinkedHashMap", exception);
        }
    }

    private LinkedHashCollectionHelper() {
    }

    static {
        Constructor<?> constructor;
        Constructor<?> constructor2;
        Class<?> clazz;
        Class<?> clazz2;
        CAPACITY_CTOR_SIG = new Class[]{Integer.TYPE, Float.TYPE};
        LOAD_FACTOR = new Float(0.75f);
        try {
            clazz2 = Class.forName("java.util.LinkedHashSet");
            clazz = Class.forName("java.util.LinkedHashMap");
            constructor2 = clazz2.getConstructor(CAPACITY_CTOR_SIG);
            constructor = clazz.getConstructor(CAPACITY_CTOR_SIG);
        }
        catch (Throwable throwable) {
            clazz2 = null;
            clazz = null;
            constructor2 = null;
            constructor = null;
        }
        SET_CLASS = clazz2;
        MAP_CLASS = clazz;
        SET_CAPACITY_CTOR = constructor2;
        MAP_CAPACITY_CTOR = constructor;
    }
}

