/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.util.Iterator;
import java.util.List;
import org.hibernate.util.EmptyIterator;

public class JoinedIterator
implements Iterator {
    private static final Iterator[] ITERATORS = new Iterator[0];
    private Iterator[] iterators;
    private int currentIteratorIndex;
    private Iterator currentIterator;
    private Iterator lastUsedIterator;

    public JoinedIterator(List list) {
        this(list.toArray(ITERATORS));
    }

    public JoinedIterator(Iterator[] iteratorArray) {
        if (iteratorArray == null) {
            throw new NullPointerException("Unexpected NULL iterators argument");
        }
        this.iterators = iteratorArray;
    }

    public JoinedIterator(Iterator iterator, Iterator iterator2) {
        this(new Iterator[]{iterator, iterator2});
    }

    public boolean hasNext() {
        this.updateCurrentIterator();
        return this.currentIterator.hasNext();
    }

    public Object next() {
        this.updateCurrentIterator();
        return this.currentIterator.next();
    }

    public void remove() {
        this.updateCurrentIterator();
        this.lastUsedIterator.remove();
    }

    protected void updateCurrentIterator() {
        if (this.currentIterator == null) {
            this.currentIterator = this.iterators.length == 0 ? EmptyIterator.INSTANCE : this.iterators[0];
            this.lastUsedIterator = this.currentIterator;
        }
        while (!this.currentIterator.hasNext() && this.currentIteratorIndex < this.iterators.length - 1) {
            ++this.currentIteratorIndex;
            this.currentIterator = this.iterators[this.currentIteratorIndex];
        }
    }
}

