/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.util.StringHelper;

public final class JDBCExceptionReporter {
    public static final Log log = LogFactory.getLog((Class)JDBCExceptionReporter.class);
    public static final String DEFAULT_EXCEPTION_MSG = "SQL Exception";
    public static final String DEFAULT_WARNING_MSG = "SQL Warning";

    private JDBCExceptionReporter() {
    }

    public static void logAndClearWarnings(Connection connection) {
        if (log.isWarnEnabled()) {
            try {
                JDBCExceptionReporter.logWarnings(connection.getWarnings());
            }
            catch (SQLException sQLException) {
                log.debug((Object)"could not log warnings", (Throwable)sQLException);
            }
        }
        try {
            connection.clearWarnings();
        }
        catch (SQLException sQLException) {
            log.debug((Object)"could not clear warnings", (Throwable)sQLException);
        }
    }

    public static void logWarnings(SQLWarning sQLWarning) {
        JDBCExceptionReporter.logWarnings(sQLWarning, null);
    }

    public static void logWarnings(SQLWarning sQLWarning, String string) {
        if (log.isWarnEnabled()) {
            if (log.isDebugEnabled() && sQLWarning != null) {
                string = StringHelper.isNotEmpty(string) ? string : DEFAULT_WARNING_MSG;
                log.debug((Object)string, (Throwable)sQLWarning);
            }
            while (sQLWarning != null) {
                StringBuffer stringBuffer = new StringBuffer(30).append("SQL Warning: ").append(sQLWarning.getErrorCode()).append(", SQLState: ").append(sQLWarning.getSQLState());
                log.warn((Object)stringBuffer.toString());
                log.warn((Object)sQLWarning.getMessage());
                sQLWarning = sQLWarning.getNextWarning();
            }
        }
    }

    public static void logExceptions(SQLException sQLException) {
        JDBCExceptionReporter.logExceptions(sQLException, null);
    }

    public static void logExceptions(SQLException sQLException, String string) {
        if (log.isErrorEnabled()) {
            if (log.isDebugEnabled()) {
                string = StringHelper.isNotEmpty(string) ? string : DEFAULT_EXCEPTION_MSG;
                log.debug((Object)string, (Throwable)sQLException);
            }
            while (sQLException != null) {
                StringBuffer stringBuffer = new StringBuffer(30).append("SQL Error: ").append(sQLException.getErrorCode()).append(", SQLState: ").append(sQLException.getSQLState());
                log.warn((Object)stringBuffer.toString());
                log.error((Object)sQLException.getMessage());
                sQLException = sQLException.getNextException();
            }
        }
    }
}

