/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.SequencedHashMap;

public final class IdentityMap
implements Map {
    private final Map map;
    private transient Map.Entry[] entryArray = new Map.Entry[0];
    private transient boolean dirty = false;

    public static Map instantiate(int n) {
        return new IdentityMap(new HashMap(n));
    }

    public static Map instantiateSequenced(int n) {
        return new IdentityMap((Map)new SequencedHashMap(n));
    }

    private IdentityMap(Map map) {
        this.map = map;
        this.dirty = true;
    }

    public static Map.Entry[] concurrentEntries(Map map) {
        return ((IdentityMap)map).entryArray();
    }

    public static List entries(Map map) {
        return ((IdentityMap)map).entryList();
    }

    public static Iterator keyIterator(Map map) {
        return ((IdentityMap)map).keyIterator();
    }

    public Iterator keyIterator() {
        return new KeyIterator(this.map.keySet().iterator());
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object object) {
        IdentityKey identityKey = new IdentityKey(object);
        return this.map.containsKey(identityKey);
    }

    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    public Object get(Object object) {
        IdentityKey identityKey = new IdentityKey(object);
        return this.map.get(identityKey);
    }

    public Object put(Object object, Object object2) {
        this.dirty = true;
        return this.map.put(new IdentityKey(object), object2);
    }

    public Object remove(Object object) {
        this.dirty = true;
        IdentityKey identityKey = new IdentityKey(object);
        return this.map.remove(identityKey);
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.dirty = true;
        this.entryArray = null;
        this.map.clear();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        HashSet<IdentityMapEntry> hashSet = new HashSet<IdentityMapEntry>(this.map.size());
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            hashSet.add(new IdentityMapEntry(((IdentityKey)entry.getKey()).key, entry.getValue()));
        }
        return hashSet;
    }

    public List entryList() {
        ArrayList<IdentityMapEntry> arrayList = new ArrayList<IdentityMapEntry>(this.map.size());
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            arrayList.add(new IdentityMapEntry(((IdentityKey)entry.getKey()).key, entry.getValue()));
        }
        return arrayList;
    }

    public Map.Entry[] entryArray() {
        if (this.dirty) {
            this.entryArray = new Map.Entry[this.map.size()];
            Iterator iterator = this.map.entrySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.entryArray[n++] = new IdentityMapEntry(((IdentityKey)entry.getKey()).key, entry.getValue());
            }
            this.dirty = false;
        }
        return this.entryArray;
    }

    public static Object serialize(Map map) {
        return ((IdentityMap)map).map;
    }

    public static Map deserialize(Object object) {
        return new IdentityMap((Map)object);
    }

    public String toString() {
        return this.map.toString();
    }

    public static Map invert(Map map) {
        Map map2 = IdentityMap.instantiate(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            map2.put(entry.getValue(), entry.getKey());
        }
        return map2;
    }

    public static final class IdentityKey
    implements Serializable {
        private Object key;

        IdentityKey(Object object) {
            this.key = object;
        }

        public boolean equals(Object object) {
            return this.key == ((IdentityKey)object).key;
        }

        public int hashCode() {
            return System.identityHashCode(this.key);
        }

        public String toString() {
            return this.key.toString();
        }

        public Object getRealKey() {
            return this.key;
        }
    }

    public static final class IdentityMapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        IdentityMapEntry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }
    }

    static final class KeyIterator
    implements Iterator {
        private final Iterator identityKeyIterator;

        private KeyIterator(Iterator iterator) {
            this.identityKeyIterator = iterator;
        }

        public boolean hasNext() {
            return this.identityKeyIterator.hasNext();
        }

        public Object next() {
            return ((IdentityKey)this.identityKeyIterator.next()).key;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

