/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.AssertionFailure;

public final class GetGeneratedKeysHelper {
    private static final Integer RETURN_GENERATED_KEYS;
    private static final Method PREPARE_STATEMENT_METHOD;
    private static final Method GET_GENERATED_KEYS_METHOD;

    private GetGeneratedKeysHelper() {
    }

    public static PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        Object[] objectArray = new Object[]{string, RETURN_GENERATED_KEYS};
        try {
            return (PreparedStatement)PREPARE_STATEMENT_METHOD.invoke((Object)connection, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof SQLException) {
                throw (SQLException)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            throw new AssertionFailure("InvocationTargetException preparing statement capable of returning generated keys (JDBC3)", invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionFailure("IllegalAccessException preparing statement capable of returning generated keys (JDBC3)", illegalAccessException);
        }
    }

    public static ResultSet getGeneratedKey(PreparedStatement preparedStatement) throws SQLException {
        try {
            return (ResultSet)GET_GENERATED_KEYS_METHOD.invoke((Object)preparedStatement, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof SQLException) {
                throw (SQLException)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            throw new AssertionFailure("InvocationTargetException extracting generated keys (JDBC3)", invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionFailure("IllegalAccessException extracting generated keys (JDBC3)", illegalAccessException);
        }
    }

    static {
        try {
            int n = Statement.class.getDeclaredField("RETURN_GENERATED_KEYS").getInt(PreparedStatement.class);
            RETURN_GENERATED_KEYS = new Integer(n);
            PREPARE_STATEMENT_METHOD = Connection.class.getMethod("prepareStatement", String.class, Integer.TYPE);
            GET_GENERATED_KEYS_METHOD = Statement.class.getDeclaredMethod("getGeneratedKeys", null);
        }
        catch (Exception exception) {
            throw new AssertionFailure("could not initialize getGeneratedKeys() support", exception);
        }
    }
}

