/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.util.ConfigHelper;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DTDEntityResolver
implements EntityResolver,
Serializable {
    private static final Log log = LogFactory.getLog((Class)DTDEntityResolver.class);
    private static final String HIBERNATE_NAMESPACE = "http://hibernate.sourceforge.net/";
    private static final String USER_NAMESPACE = "classpath://";

    /*
     * Enabled aggressive block sorting
     */
    public InputSource resolveEntity(String string, String string2) {
        if (string2 == null) return null;
        log.debug((Object)("trying to resolve system-id [" + string2 + "]"));
        if (string2.startsWith(HIBERNATE_NAMESPACE)) {
            log.debug((Object)"recognized hibernate namespace; attempting to resolve on classpath under org/hibernate/");
            String string3 = "org/hibernate/" + string2.substring(HIBERNATE_NAMESPACE.length());
            InputStream inputStream = this.resolveInHibernateNamespace(string3);
            if (inputStream == null) {
                log.debug((Object)("unable to locate [" + string2 + "] on classpath"));
                if (string2.substring(HIBERNATE_NAMESPACE.length()).indexOf("2.0") <= -1) return null;
                log.error((Object)"Don't use old DTDs, read the Hibernate 3.x Migration Guide!");
                return null;
            }
            log.debug((Object)("located [" + string2 + "] in classpath"));
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setPublicId(string);
            inputSource.setSystemId(string2);
            return inputSource;
        }
        if (!string2.startsWith(USER_NAMESPACE)) return null;
        log.debug((Object)"recognized local namespace; attempting to resolve on classpath");
        String string4 = string2.substring(USER_NAMESPACE.length());
        InputStream inputStream = this.resolveInLocalNamespace(string4);
        if (inputStream == null) {
            log.debug((Object)("unable to locate [" + string2 + "] on classpath"));
            return null;
        }
        log.debug((Object)("located [" + string2 + "] in classpath"));
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setPublicId(string);
        inputSource.setSystemId(string2);
        return inputSource;
    }

    protected InputStream resolveInHibernateNamespace(String string) {
        return this.getClass().getClassLoader().getResourceAsStream(string);
    }

    protected InputStream resolveInLocalNamespace(String string) {
        try {
            return ConfigHelper.getUserResourceAsStream(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

