/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;

public final class ConfigHelper {
    private static final Log log = LogFactory.getLog((Class)ConfigHelper.class);

    public static final URL locateConfig(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return ConfigHelper.findAsResource(string);
        }
    }

    public static final URL findAsResource(String string) {
        URL uRL = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            uRL = classLoader.getResource(string);
        }
        if (uRL != null) {
            return uRL;
        }
        uRL = ConfigHelper.class.getClassLoader().getResource(string);
        if (uRL != null) {
            return uRL;
        }
        uRL = ClassLoader.getSystemClassLoader().getResource(string);
        return uRL;
    }

    public static final InputStream getConfigStream(String string) throws HibernateException {
        URL uRL = ConfigHelper.locateConfig(string);
        if (uRL == null) {
            String string2 = "Unable to locate config file: " + string;
            log.fatal((Object)string2);
            throw new HibernateException(string2);
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            throw new HibernateException("Unable to open config file: " + string, iOException);
        }
    }

    public static final Reader getConfigStreamReader(String string) throws HibernateException {
        return new InputStreamReader(ConfigHelper.getConfigStream(string));
    }

    public static final Properties getConfigProperties(String string) throws HibernateException {
        try {
            Properties properties = new Properties();
            properties.load(ConfigHelper.getConfigStream(string));
            return properties;
        }
        catch (IOException iOException) {
            throw new HibernateException("Unable to load properties from specified config file: " + string, iOException);
        }
    }

    private ConfigHelper() {
    }

    public static InputStream getResourceAsStream(String string) {
        String string2 = string.startsWith("/") ? string.substring(1) : string;
        InputStream inputStream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(string2);
        }
        if (inputStream == null) {
            inputStream = Environment.class.getResourceAsStream(string);
        }
        if (inputStream == null) {
            inputStream = Environment.class.getClassLoader().getResourceAsStream(string2);
        }
        if (inputStream == null) {
            throw new HibernateException(string + " not found");
        }
        return inputStream;
    }

    public static InputStream getUserResourceAsStream(String string) {
        boolean bl = string.startsWith("/");
        String string2 = bl ? string.substring(1) : string;
        InputStream inputStream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(string)) == null && bl) {
            inputStream = classLoader.getResourceAsStream(string2);
        }
        if (inputStream == null) {
            inputStream = Environment.class.getClassLoader().getResourceAsStream(string);
        }
        if (inputStream == null && bl) {
            inputStream = Environment.class.getClassLoader().getResourceAsStream(string2);
        }
        if (inputStream == null) {
            throw new HibernateException(string + " not found");
        }
        return inputStream;
    }
}

