/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import [Ljava.lang.Byte;;
import [Ljava.lang.Character;;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.hibernate.Hibernate;
import org.hibernate.MappingException;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.property.BackrefPropertyAccessor;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.AdaptedImmutableType;
import org.hibernate.type.ArrayType;
import org.hibernate.type.BagType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeCustomType;
import org.hibernate.type.CurrencyType;
import org.hibernate.type.CustomCollectionType;
import org.hibernate.type.CustomType;
import org.hibernate.type.DbTimestampType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.IdentifierBagType;
import org.hibernate.type.ListType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MapType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.OrderedMapType;
import org.hibernate.type.OrderedSetType;
import org.hibernate.type.SetType;
import org.hibernate.type.SortedMapType;
import org.hibernate.type.SortedSetType;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.hibernate.util.ReflectHelper;

public final class TypeFactory {
    private static final Map BASIC_TYPES;

    private TypeFactory() {
        throw new UnsupportedOperationException();
    }

    public static EntityType oneToOne(String string, ForeignKeyDirection foreignKeyDirection, String string2, boolean bl, boolean bl2, boolean bl3, String string3, String string4) {
        return new OneToOneType(string, foreignKeyDirection, string2, bl, bl2, bl3, string3, string4);
    }

    public static EntityType manyToOne(String string) {
        return new ManyToOneType(string);
    }

    public static EntityType manyToOne(String string, boolean bl) {
        return new ManyToOneType(string, bl);
    }

    public static EntityType manyToOne(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return new ManyToOneType(string, string2, bl, bl2, bl3, bl4);
    }

    public static Type basic(String string) {
        return (Type)BASIC_TYPES.get(string);
    }

    public static Type heuristicType(String string) throws MappingException {
        return TypeFactory.heuristicType(string, null);
    }

    public static Type heuristicType(String string, Properties properties) throws MappingException {
        Type type = TypeFactory.basic(string);
        if (type == null) {
            Class clazz;
            try {
                clazz = ReflectHelper.classForName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
            if (clazz != null) {
                if (Type.class.isAssignableFrom(clazz)) {
                    try {
                        type = (Type)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        throw new MappingException("Could not instantiate Type: " + clazz.getName(), exception);
                    }
                    TypeFactory.injectParameters(type, properties);
                } else if (CompositeUserType.class.isAssignableFrom(clazz)) {
                    type = new CompositeCustomType(clazz, properties);
                } else if (UserType.class.isAssignableFrom(clazz)) {
                    type = new CustomType(clazz, properties);
                } else if (Lifecycle.class.isAssignableFrom(clazz)) {
                    type = Hibernate.entity(clazz);
                } else if (Serializable.class.isAssignableFrom(clazz)) {
                    type = Hibernate.serializable(clazz);
                }
            }
        }
        return type;
    }

    public static CollectionType customCollection(String string, String string2, String string3, boolean bl) {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MappingException("user colllection type class not found: " + string, classNotFoundException);
        }
        return new CustomCollectionType(clazz, string2, string3, bl);
    }

    public static CollectionType array(String string, String string2, boolean bl, Class clazz) {
        return new ArrayType(string, string2, clazz, bl);
    }

    public static CollectionType list(String string, String string2, boolean bl) {
        return new ListType(string, string2, bl);
    }

    public static CollectionType bag(String string, String string2, boolean bl) {
        return new BagType(string, string2, bl);
    }

    public static CollectionType idbag(String string, String string2, boolean bl) {
        return new IdentifierBagType(string, string2, bl);
    }

    public static CollectionType map(String string, String string2, boolean bl) {
        return new MapType(string, string2, bl);
    }

    public static CollectionType orderedMap(String string, String string2, boolean bl) {
        return new OrderedMapType(string, string2, bl);
    }

    public static CollectionType set(String string, String string2, boolean bl) {
        return new SetType(string, string2, bl);
    }

    public static CollectionType orderedSet(String string, String string2, boolean bl) {
        return new OrderedSetType(string, string2, bl);
    }

    public static CollectionType sortedMap(String string, String string2, boolean bl, Comparator comparator) {
        return new SortedMapType(string, string2, comparator, bl);
    }

    public static CollectionType sortedSet(String string, String string2, boolean bl, Comparator comparator) {
        return new SortedSetType(string, string2, comparator, bl);
    }

    public static void injectParameters(Object object, Properties properties) {
        if (object instanceof ParameterizedType) {
            ((ParameterizedType)object).setParameterValues(properties);
        } else if (properties != null && !properties.isEmpty()) {
            throw new MappingException("type is not parameterized: " + object.getClass().getName());
        }
    }

    public static void deepCopy(Object[] objectArray, Type[] typeArray, boolean[] blArray, Object[] objectArray2, SessionImplementor sessionImplementor) {
        for (int i = 0; i < typeArray.length; ++i) {
            if (!blArray[i]) continue;
            objectArray2[i] = objectArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || objectArray[i] == BackrefPropertyAccessor.UNKNOWN ? objectArray[i] : typeArray[i].deepCopy(objectArray[i], sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
        }
    }

    public static void beforeAssemble(Serializable[] serializableArray, Type[] typeArray, SessionImplementor sessionImplementor) {
        for (int i = 0; i < typeArray.length; ++i) {
            if (serializableArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || serializableArray[i] == BackrefPropertyAccessor.UNKNOWN) continue;
            typeArray[i].beforeAssemble(serializableArray[i], sessionImplementor);
        }
    }

    public static Object[] assemble(Serializable[] serializableArray, Type[] typeArray, SessionImplementor sessionImplementor, Object object) {
        Object[] objectArray = new Object[serializableArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            objectArray[i] = serializableArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || serializableArray[i] == BackrefPropertyAccessor.UNKNOWN ? serializableArray[i] : typeArray[i].assemble(serializableArray[i], sessionImplementor, object);
        }
        return objectArray;
    }

    public static Serializable[] disassemble(Object[] objectArray, Type[] typeArray, boolean[] blArray, SessionImplementor sessionImplementor, Object object) {
        Serializable[] serializableArray = new Serializable[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            serializableArray[i] = blArray != null && blArray[i] ? LazyPropertyInitializer.UNFETCHED_PROPERTY : (objectArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || objectArray[i] == BackrefPropertyAccessor.UNKNOWN ? (Serializable)objectArray[i] : typeArray[i].disassemble(objectArray[i], sessionImplementor, object));
        }
        return serializableArray;
    }

    public static Object[] replace(Object[] objectArray, Object[] objectArray2, Type[] typeArray, SessionImplementor sessionImplementor, Object object, Map map) {
        Object[] objectArray3 = new Object[objectArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            objectArray3[i] = objectArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || objectArray[i] == BackrefPropertyAccessor.UNKNOWN ? objectArray2[i] : typeArray[i].replace(objectArray[i], objectArray2[i], sessionImplementor, object, map);
        }
        return objectArray3;
    }

    public static Object[] replace(Object[] objectArray, Object[] objectArray2, Type[] typeArray, SessionImplementor sessionImplementor, Object object, Map map, ForeignKeyDirection foreignKeyDirection) {
        Object[] objectArray3 = new Object[objectArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            objectArray3[i] = objectArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || objectArray[i] == BackrefPropertyAccessor.UNKNOWN ? objectArray2[i] : typeArray[i].replace(objectArray[i], objectArray2[i], sessionImplementor, object, map, foreignKeyDirection);
        }
        return objectArray3;
    }

    public static Object[] replaceAssociations(Object[] objectArray, Object[] objectArray2, Type[] typeArray, SessionImplementor sessionImplementor, Object object, Map map, ForeignKeyDirection foreignKeyDirection) {
        Object[] objectArray3 = new Object[objectArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            if (objectArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || objectArray[i] == BackrefPropertyAccessor.UNKNOWN) {
                objectArray3[i] = objectArray2[i];
                continue;
            }
            if (typeArray[i].isComponentType()) {
                AbstractComponentType abstractComponentType = (AbstractComponentType)typeArray[i];
                Type[] typeArray2 = abstractComponentType.getSubtypes();
                Object[] objectArray4 = objectArray[i] == null ? new Object[typeArray2.length] : abstractComponentType.getPropertyValues(objectArray[i], sessionImplementor);
                Object[] objectArray5 = abstractComponentType.getPropertyValues(objectArray2[i], sessionImplementor);
                TypeFactory.replaceAssociations(objectArray4, objectArray5, typeArray2, sessionImplementor, null, map, foreignKeyDirection);
                objectArray3[i] = objectArray2[i];
                continue;
            }
            objectArray3[i] = !typeArray[i].isAssociationType() ? objectArray2[i] : typeArray[i].replace(objectArray[i], objectArray2[i], sessionImplementor, object, map, foreignKeyDirection);
        }
        return objectArray3;
    }

    public static int[] findDirty(StandardProperty[] standardPropertyArray, Object[] objectArray, Object[] objectArray2, boolean[][] blArray, boolean bl, SessionImplementor sessionImplementor) {
        int[] nArray = null;
        int n = 0;
        int n2 = standardPropertyArray.length;
        for (int i = 0; i < n2; ++i) {
            boolean bl2;
            boolean bl3 = bl2 = objectArray[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && standardPropertyArray[i].isDirtyCheckable(bl) && standardPropertyArray[i].getType().isDirty(objectArray2[i], objectArray[i], blArray[i], sessionImplementor);
            if (!bl2) continue;
            if (nArray == null) {
                nArray = new int[n2];
            }
            nArray[n++] = i;
        }
        if (n == 0) {
            return null;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static int[] findModified(StandardProperty[] standardPropertyArray, Object[] objectArray, Object[] objectArray2, boolean[][] blArray, boolean bl, SessionImplementor sessionImplementor) {
        int[] nArray = null;
        int n = 0;
        int n2 = standardPropertyArray.length;
        for (int i = 0; i < n2; ++i) {
            boolean bl2;
            boolean bl3 = bl2 = objectArray[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && standardPropertyArray[i].isDirtyCheckable(bl) && standardPropertyArray[i].getType().isModified(objectArray2[i], objectArray[i], blArray[i], sessionImplementor);
            if (!bl2) continue;
            if (nArray == null) {
                nArray = new int[n2];
            }
            nArray[n++] = i;
        }
        if (n == 0) {
            return null;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    static {
        HashMap<String, Type> hashMap = new HashMap<String, Type>();
        hashMap.put(Boolean.TYPE.getName(), Hibernate.BOOLEAN);
        hashMap.put(Long.TYPE.getName(), Hibernate.LONG);
        hashMap.put(Short.TYPE.getName(), Hibernate.SHORT);
        hashMap.put(Integer.TYPE.getName(), Hibernate.INTEGER);
        hashMap.put(Byte.TYPE.getName(), Hibernate.BYTE);
        hashMap.put(Float.TYPE.getName(), Hibernate.FLOAT);
        hashMap.put(Double.TYPE.getName(), Hibernate.DOUBLE);
        hashMap.put(Character.TYPE.getName(), Hibernate.CHARACTER);
        hashMap.put(Hibernate.CHARACTER.getName(), Hibernate.CHARACTER);
        hashMap.put(Hibernate.INTEGER.getName(), Hibernate.INTEGER);
        hashMap.put(Hibernate.STRING.getName(), Hibernate.STRING);
        hashMap.put(Hibernate.DATE.getName(), Hibernate.DATE);
        hashMap.put(Hibernate.TIME.getName(), Hibernate.TIME);
        hashMap.put(Hibernate.TIMESTAMP.getName(), Hibernate.TIMESTAMP);
        hashMap.put("dbtimestamp", new DbTimestampType());
        hashMap.put(Hibernate.LOCALE.getName(), Hibernate.LOCALE);
        hashMap.put(Hibernate.CALENDAR.getName(), Hibernate.CALENDAR);
        hashMap.put(Hibernate.CALENDAR_DATE.getName(), Hibernate.CALENDAR_DATE);
        hashMap.put(Hibernate.CURRENCY.getName(), Hibernate.CURRENCY);
        hashMap.put(Hibernate.TIMEZONE.getName(), Hibernate.TIMEZONE);
        hashMap.put(Hibernate.CLASS.getName(), Hibernate.CLASS);
        hashMap.put(Hibernate.TRUE_FALSE.getName(), Hibernate.TRUE_FALSE);
        hashMap.put(Hibernate.YES_NO.getName(), Hibernate.YES_NO);
        hashMap.put(Hibernate.BINARY.getName(), Hibernate.BINARY);
        hashMap.put(Hibernate.TEXT.getName(), Hibernate.TEXT);
        hashMap.put(Hibernate.BLOB.getName(), Hibernate.BLOB);
        hashMap.put(Hibernate.CLOB.getName(), Hibernate.CLOB);
        hashMap.put(Hibernate.BIG_DECIMAL.getName(), Hibernate.BIG_DECIMAL);
        hashMap.put(Hibernate.BIG_INTEGER.getName(), Hibernate.BIG_INTEGER);
        hashMap.put(Hibernate.SERIALIZABLE.getName(), Hibernate.SERIALIZABLE);
        hashMap.put(Hibernate.OBJECT.getName(), Hibernate.OBJECT);
        hashMap.put(Boolean.class.getName(), Hibernate.BOOLEAN);
        hashMap.put(Long.class.getName(), Hibernate.LONG);
        hashMap.put(Short.class.getName(), Hibernate.SHORT);
        hashMap.put(Integer.class.getName(), Hibernate.INTEGER);
        hashMap.put(Byte.class.getName(), Hibernate.BYTE);
        hashMap.put(Float.class.getName(), Hibernate.FLOAT);
        hashMap.put(Double.class.getName(), Hibernate.DOUBLE);
        hashMap.put(Character.class.getName(), Hibernate.CHARACTER);
        hashMap.put(String.class.getName(), Hibernate.STRING);
        hashMap.put(java.util.Date.class.getName(), Hibernate.TIMESTAMP);
        hashMap.put(Time.class.getName(), Hibernate.TIME);
        hashMap.put(Timestamp.class.getName(), Hibernate.TIMESTAMP);
        hashMap.put(Date.class.getName(), Hibernate.DATE);
        hashMap.put(BigDecimal.class.getName(), Hibernate.BIG_DECIMAL);
        hashMap.put(BigInteger.class.getName(), Hibernate.BIG_INTEGER);
        hashMap.put(Locale.class.getName(), Hibernate.LOCALE);
        hashMap.put(Calendar.class.getName(), Hibernate.CALENDAR);
        hashMap.put(GregorianCalendar.class.getName(), Hibernate.CALENDAR);
        if (CurrencyType.CURRENCY_CLASS != null) {
            hashMap.put(CurrencyType.CURRENCY_CLASS.getName(), Hibernate.CURRENCY);
        }
        hashMap.put(TimeZone.class.getName(), Hibernate.TIMEZONE);
        hashMap.put(Object.class.getName(), Hibernate.OBJECT);
        hashMap.put(Class.class.getName(), Hibernate.CLASS);
        hashMap.put([B.class.getName(), Hibernate.BINARY);
        hashMap.put("byte[]", Hibernate.BINARY);
        hashMap.put(Byte;.class.getName(), Hibernate.WRAPPER_BINARY);
        hashMap.put("Byte[]", Hibernate.WRAPPER_BINARY);
        hashMap.put([C.class.getName(), Hibernate.CHAR_ARRAY);
        hashMap.put("char[]", Hibernate.CHAR_ARRAY);
        hashMap.put(Character;.class.getName(), Hibernate.CHARACTER_ARRAY);
        hashMap.put("Character[]", Hibernate.CHARACTER_ARRAY);
        hashMap.put(Blob.class.getName(), Hibernate.BLOB);
        hashMap.put(Clob.class.getName(), Hibernate.CLOB);
        hashMap.put(Serializable.class.getName(), Hibernate.SERIALIZABLE);
        AdaptedImmutableType adaptedImmutableType = new AdaptedImmutableType(Hibernate.DATE);
        hashMap.put(adaptedImmutableType.getName(), adaptedImmutableType);
        adaptedImmutableType = new AdaptedImmutableType(Hibernate.TIME);
        hashMap.put(adaptedImmutableType.getName(), adaptedImmutableType);
        adaptedImmutableType = new AdaptedImmutableType(Hibernate.TIMESTAMP);
        hashMap.put(adaptedImmutableType.getName(), adaptedImmutableType);
        adaptedImmutableType = new AdaptedImmutableType(new DbTimestampType());
        hashMap.put(adaptedImmutableType.getName(), adaptedImmutableType);
        adaptedImmutableType = new AdaptedImmutableType(Hibernate.CALENDAR);
        hashMap.put(adaptedImmutableType.getName(), adaptedImmutableType);
        adaptedImmutableType = new AdaptedImmutableType(Hibernate.CALENDAR_DATE);
        hashMap.put(adaptedImmutableType.getName(), adaptedImmutableType);
        adaptedImmutableType = new AdaptedImmutableType(Hibernate.SERIALIZABLE);
        hashMap.put(adaptedImmutableType.getName(), adaptedImmutableType);
        adaptedImmutableType = new AdaptedImmutableType(Hibernate.BINARY);
        hashMap.put(adaptedImmutableType.getName(), adaptedImmutableType);
        BASIC_TYPES = Collections.unmodifiableMap(hashMap);
    }
}

