/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.LiteralType;
import org.hibernate.type.MutableType;
import org.hibernate.type.VersionType;
import org.hibernate.util.ComparableComparator;

public class TimestampType
extends MutableType
implements VersionType,
LiteralType {
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public Object get(ResultSet resultSet, String string) throws SQLException {
        return resultSet.getTimestamp(string);
    }

    public Class getReturnedClass() {
        return Date.class;
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws SQLException {
        Timestamp timestamp = object instanceof Timestamp ? (Timestamp)object : new Timestamp(((Date)object).getTime());
        preparedStatement.setTimestamp(n, timestamp);
    }

    public int sqlType() {
        return 93;
    }

    public String getName() {
        return "timestamp";
    }

    public String toString(Object object) {
        return new SimpleDateFormat(TIMESTAMP_FORMAT).format((Date)object);
    }

    public Object deepCopyNotNull(Object object) {
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            Timestamp timestamp2 = new Timestamp(timestamp.getTime());
            timestamp2.setNanos(timestamp.getNanos());
            return timestamp2;
        }
        Date date = (Date)object;
        return new Date(date.getTime());
    }

    public boolean isEqual(Object object, Object object2) {
        int n;
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        long l = ((Date)object).getTime();
        long l2 = ((Date)object2).getTime();
        boolean bl = object instanceof Timestamp;
        boolean bl2 = object2 instanceof Timestamp;
        int n2 = bl ? ((Timestamp)object).getNanos() : 0;
        int n3 = n = bl2 ? ((Timestamp)object2).getNanos() : 0;
        if (!Environment.jvmHasJDK14Timestamp()) {
            l += (long)(n2 / 1000000);
            l2 += (long)(n / 1000000);
        }
        if (l != l2) {
            return false;
        }
        if (bl && bl2) {
            int n4 = n2 % 1000000;
            int n5 = n % 1000000;
            return n4 == n5;
        }
        return true;
    }

    public int getHashCode(Object object, EntityMode entityMode) {
        Date date = (Date)object;
        return new Long(date.getTime() / 1000L).hashCode();
    }

    public Object next(Object object, SessionImplementor sessionImplementor) {
        return this.seed(sessionImplementor);
    }

    public Object seed(SessionImplementor sessionImplementor) {
        return new Timestamp(System.currentTimeMillis());
    }

    public Comparator getComparator() {
        return ComparableComparator.INSTANCE;
    }

    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        return '\'' + new Timestamp(((Date)object).getTime()).toString() + '\'';
    }

    public Object fromStringValue(String string) throws HibernateException {
        try {
            return new Timestamp(new SimpleDateFormat(TIMESTAMP_FORMAT).parse(string).getTime());
        }
        catch (ParseException parseException) {
            throw new HibernateException("could not parse XML", parseException);
        }
    }
}

