/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.LiteralType;
import org.hibernate.type.MutableType;

public class TimeType
extends MutableType
implements LiteralType {
    private static final String TIME_FORMAT = "HH:mm:ss";

    public Object get(ResultSet resultSet, String string) throws SQLException {
        return resultSet.getTime(string);
    }

    public Class getReturnedClass() {
        return Date.class;
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws SQLException {
        Time time = object instanceof Time ? (Time)object : new Time(((Date)object).getTime());
        preparedStatement.setTime(n, time);
    }

    public int sqlType() {
        return 92;
    }

    public String getName() {
        return "time";
    }

    public String toString(Object object) {
        return new SimpleDateFormat(TIME_FORMAT).format((Date)object);
    }

    public boolean isEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Date date = (Date)object;
        Date date2 = (Date)object2;
        if (date.getTime() == date2.getTime()) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(date);
        calendar2.setTime(date2);
        return calendar.get(11) == calendar2.get(11) && calendar.get(12) == calendar2.get(12) && calendar.get(13) == calendar2.get(13) && calendar.get(14) == calendar2.get(14);
    }

    public int getHashCode(Object object, EntityMode entityMode) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)object);
        int n = 1;
        n = 31 * n + calendar.get(11);
        n = 31 * n + calendar.get(12);
        n = 31 * n + calendar.get(13);
        n = 31 * n + calendar.get(14);
        return n;
    }

    public Object deepCopyNotNull(Object object) {
        return new Time(((Date)object).getTime());
    }

    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        return '\'' + new Time(((Date)object).getTime()).toString() + '\'';
    }

    public Object fromStringValue(String string) throws HibernateException {
        try {
            return new SimpleDateFormat(TIME_FORMAT).parse(string);
        }
        catch (ParseException parseException) {
            throw new HibernateException("could not parse XML", parseException);
        }
    }
}

