/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.VersionType;
import org.hibernate.util.ComparableComparator;

public class ShortType
extends PrimitiveType
implements DiscriminatorType,
VersionType {
    private static final Short ZERO = new Short(0);

    public Serializable getDefaultValue() {
        return ZERO;
    }

    public Object get(ResultSet resultSet, String string) throws SQLException {
        return new Short(resultSet.getShort(string));
    }

    public Class getPrimitiveClass() {
        return Short.TYPE;
    }

    public Class getReturnedClass() {
        return Short.class;
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws SQLException {
        preparedStatement.setShort(n, (Short)object);
    }

    public int sqlType() {
        return 5;
    }

    public String getName() {
        return "short";
    }

    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        return object.toString();
    }

    public Object stringToObject(String string) throws Exception {
        return new Short(string);
    }

    public Object next(Object object, SessionImplementor sessionImplementor) {
        return new Short((short)((Short)object + 1));
    }

    public Object seed(SessionImplementor sessionImplementor) {
        return ZERO;
    }

    public Comparator getComparator() {
        return ComparableComparator.INSTANCE;
    }

    public Object fromStringValue(String string) {
        return new Short(string);
    }
}

