/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.MutableType;
import org.hibernate.type.SerializationException;
import org.hibernate.util.SerializationHelper;

public class SerializableType
extends MutableType {
    private final Class serializableClass;

    public SerializableType(Class clazz) {
        this.serializableClass = clazz;
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws HibernateException, SQLException {
        Hibernate.BINARY.set(preparedStatement, SerializableType.toBytes(object), n);
    }

    public Object get(ResultSet resultSet, String string) throws HibernateException, SQLException {
        byte[] byArray = (byte[])Hibernate.BINARY.get(resultSet, string);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        return SerializableType.fromBytes(byArray);
    }

    public Class getReturnedClass() {
        return this.serializableClass;
    }

    public boolean isEqual(Object object, Object object2) throws HibernateException {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2) || Hibernate.BINARY.isEqual(SerializableType.toBytes(object), SerializableType.toBytes(object2));
    }

    public int getHashCode(Object object, EntityMode entityMode) {
        return Hibernate.BINARY.getHashCode(SerializableType.toBytes(object), entityMode);
    }

    public String toString(Object object) throws HibernateException {
        return Hibernate.BINARY.toString(SerializableType.toBytes(object));
    }

    public Object fromStringValue(String string) throws HibernateException {
        return SerializableType.fromBytes((byte[])Hibernate.BINARY.fromStringValue(string));
    }

    public String getName() {
        return this.serializableClass == Serializable.class ? "serializable" : this.serializableClass.getName();
    }

    public Object deepCopyNotNull(Object object) throws HibernateException {
        return SerializableType.fromBytes(SerializableType.toBytes(object));
    }

    private static byte[] toBytes(Object object) throws SerializationException {
        return SerializationHelper.serialize((Serializable)object);
    }

    private static Object fromBytes(byte[] byArray) throws SerializationException {
        return SerializationHelper.deserialize(byArray);
    }

    public int sqlType() {
        return Hibernate.BINARY.sqlType();
    }

    public Object assemble(Serializable serializable, SessionImplementor sessionImplementor, Object object) throws HibernateException {
        return serializable == null ? null : SerializableType.fromBytes((byte[])serializable);
    }

    public Serializable disassemble(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        return object == null ? null : SerializableType.toBytes(object);
    }
}

