/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.AbstractType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.EqualsHelper;
import org.hibernate.util.StringHelper;

public abstract class NullableType
extends AbstractType {
    private static final boolean IS_VALUE_TRACING_ENABLED = LogFactory.getLog((String)StringHelper.qualifier(Type.class.getName())).isTraceEnabled();
    private transient Log log;

    private Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog(this.getClass());
        }
        return this.log;
    }

    public abstract Object get(ResultSet var1, String var2) throws HibernateException, SQLException;

    public abstract void set(PreparedStatement var1, Object var2, int var3) throws HibernateException, SQLException;

    public abstract int sqlType();

    public String nullSafeToString(Object object) throws HibernateException {
        return object == null ? null : this.toString(object);
    }

    public abstract String toString(Object var1) throws HibernateException;

    public abstract Object fromStringValue(String var1) throws HibernateException;

    public final void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (blArray[0]) {
            this.nullSafeSet(preparedStatement, object, n);
        }
    }

    public final void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        this.nullSafeSet(preparedStatement, object, n);
    }

    public final void nullSafeSet(PreparedStatement preparedStatement, Object object, int n) throws HibernateException, SQLException {
        try {
            if (object == null) {
                if (IS_VALUE_TRACING_ENABLED) {
                    this.log().trace((Object)("binding null to parameter: " + n));
                }
                preparedStatement.setNull(n, this.sqlType());
            } else {
                if (IS_VALUE_TRACING_ENABLED) {
                    this.log().trace((Object)("binding '" + this.toString(object) + "' to parameter: " + n));
                }
                this.set(preparedStatement, object, n);
            }
        }
        catch (RuntimeException runtimeException) {
            this.log().info((Object)("could not bind value '" + this.nullSafeToString(object) + "' to parameter: " + n + "; " + runtimeException.getMessage()));
            throw runtimeException;
        }
        catch (SQLException sQLException) {
            this.log().info((Object)("could not bind value '" + this.nullSafeToString(object) + "' to parameter: " + n + "; " + sQLException.getMessage()));
            throw sQLException;
        }
    }

    public final Object nullSafeGet(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.nullSafeGet(resultSet, stringArray[0]);
    }

    public final Object nullSafeGet(ResultSet resultSet, String[] stringArray) throws HibernateException, SQLException {
        return this.nullSafeGet(resultSet, stringArray[0]);
    }

    public final Object nullSafeGet(ResultSet resultSet, String string) throws HibernateException, SQLException {
        try {
            Object object = this.get(resultSet, string);
            if (object == null || resultSet.wasNull()) {
                if (IS_VALUE_TRACING_ENABLED) {
                    this.log().trace((Object)("returning null as column: " + string));
                }
                return null;
            }
            if (IS_VALUE_TRACING_ENABLED) {
                this.log().trace((Object)("returning '" + this.toString(object) + "' as column: " + string));
            }
            return object;
        }
        catch (RuntimeException runtimeException) {
            this.log().info((Object)("could not read column value from result set: " + string + "; " + runtimeException.getMessage()));
            throw runtimeException;
        }
        catch (SQLException sQLException) {
            this.log().info((Object)("could not read column value from result set: " + string + "; " + sQLException.getMessage()));
            throw sQLException;
        }
    }

    public final Object nullSafeGet(ResultSet resultSet, String string, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.nullSafeGet(resultSet, string);
    }

    public final String toXMLString(Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        return this.toString(object);
    }

    public final Object fromXMLString(String string, Mapping mapping) throws HibernateException {
        return string == null || string.length() == 0 ? null : this.fromStringValue(string);
    }

    public final int getColumnSpan(Mapping mapping) {
        return 1;
    }

    public final int[] sqlTypes(Mapping mapping) {
        return new int[]{this.sqlType()};
    }

    public final boolean isEqual(Object object, Object object2, EntityMode entityMode) {
        return this.isEqual(object, object2);
    }

    public boolean isEqual(Object object, Object object2) {
        return EqualsHelper.equals(object, object2);
    }

    public String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        return object == null ? "null" : this.toString(object);
    }

    public Object fromXMLNode(Node node, Mapping mapping) throws HibernateException {
        return this.fromXMLString(node.getText(), mapping);
    }

    public void setToXMLNode(Node node, Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        node.setText(this.toXMLString(object, sessionFactoryImplementor));
    }

    public boolean[] toColumnNullness(Object object, Mapping mapping) {
        return object == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }

    public boolean isDirty(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException {
        return blArray[0] && this.isDirty(object, object2, sessionImplementor);
    }
}

