/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;

public class ManyToOneType
extends EntityType {
    private final boolean ignoreNotFound;

    public ManyToOneType(String string) {
        this(string, false);
    }

    public ManyToOneType(String string, boolean bl) {
        super(string, null, !bl, true, false);
        this.ignoreNotFound = false;
    }

    public ManyToOneType(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(string, string2, !bl, bl3, bl2);
        this.ignoreNotFound = bl4;
    }

    protected boolean isNullable() {
        return this.ignoreNotFound;
    }

    public boolean isAlwaysDirtyChecked() {
        return this.ignoreNotFound;
    }

    public boolean isOneToOne() {
        return false;
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        return this.getIdentifierOrUniqueKeyType(mapping).getColumnSpan(mapping);
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return this.getIdentifierOrUniqueKeyType(mapping).sqlTypes(mapping);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        this.getIdentifierOrUniqueKeyType(sessionImplementor.getFactory()).nullSafeSet(preparedStatement, this.getIdentifier(object, sessionImplementor), n, blArray, sessionImplementor);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        this.getIdentifierOrUniqueKeyType(sessionImplementor.getFactory()).nullSafeSet(preparedStatement, this.getIdentifier(object, sessionImplementor), n, sessionImplementor);
    }

    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT;
    }

    public Object hydrate(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        Serializable serializable = (Serializable)this.getIdentifierOrUniqueKeyType(sessionImplementor.getFactory()).nullSafeGet(resultSet, stringArray, sessionImplementor, null);
        this.scheduleBatchLoadIfNeeded(serializable, sessionImplementor);
        return serializable;
    }

    private void scheduleBatchLoadIfNeeded(Serializable serializable, SessionImplementor sessionImplementor) throws MappingException {
        if (this.uniqueKeyPropertyName == null && serializable != null) {
            EntityPersister entityPersister = sessionImplementor.getFactory().getEntityPersister(this.getAssociatedEntityName());
            EntityKey entityKey = new EntityKey(serializable, entityPersister, sessionImplementor.getEntityMode());
            if (!sessionImplementor.getPersistenceContext().containsEntity(entityKey)) {
                sessionImplementor.getPersistenceContext().getBatchFetchQueue().addBatchLoadableEntityKey(entityKey);
            }
        }
    }

    public boolean useLHSPrimaryKey() {
        return false;
    }

    public boolean isModified(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException {
        if (object2 == null) {
            return object != null;
        }
        if (object == null) {
            return true;
        }
        return this.getIdentifierOrUniqueKeyType(sessionImplementor.getFactory()).isDirty(object, this.getIdentifier(object2, sessionImplementor), sessionImplementor);
    }

    public Serializable disassemble(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        if (this.isNotEmbedded(sessionImplementor)) {
            return this.getIdentifierType(sessionImplementor).disassemble(object, sessionImplementor, object2);
        }
        if (object == null) {
            return null;
        }
        Serializable serializable = ForeignKeys.getEntityIdentifierIfNotUnsaved(this.getAssociatedEntityName(), object, sessionImplementor);
        if (serializable == null) {
            throw new AssertionFailure("cannot cache a reference to an object with a null id: " + this.getAssociatedEntityName());
        }
        return this.getIdentifierType(sessionImplementor).disassemble(serializable, sessionImplementor, object2);
    }

    public Object assemble(Serializable serializable, SessionImplementor sessionImplementor, Object object) throws HibernateException {
        Serializable serializable2 = this.assembleId(serializable, sessionImplementor);
        if (this.isNotEmbedded(sessionImplementor)) {
            return serializable2;
        }
        if (serializable2 == null) {
            return null;
        }
        return this.resolveIdentifier(serializable2, sessionImplementor);
    }

    private Serializable assembleId(Serializable serializable, SessionImplementor sessionImplementor) {
        return (Serializable)this.getIdentifierType(sessionImplementor).assemble(serializable, sessionImplementor, null);
    }

    public void beforeAssemble(Serializable serializable, SessionImplementor sessionImplementor) {
        this.scheduleBatchLoadIfNeeded(this.assembleId(serializable, sessionImplementor), sessionImplementor);
    }

    public boolean[] toColumnNullness(Object object, Mapping mapping) {
        boolean[] blArray = new boolean[this.getColumnSpan(mapping)];
        if (object != null) {
            Arrays.fill(blArray, true);
        }
        return blArray;
    }

    public boolean isDirty(Object object, Object object2, SessionImplementor sessionImplementor) throws HibernateException {
        if (this.isSame(object, object2, sessionImplementor.getEntityMode())) {
            return false;
        }
        Object object3 = this.getIdentifier(object, sessionImplementor);
        Object object4 = this.getIdentifier(object2, sessionImplementor);
        return this.getIdentifierType(sessionImplementor).isDirty(object3, object4, sessionImplementor);
    }

    public boolean isDirty(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException {
        if (this.isAlwaysDirtyChecked()) {
            return this.isDirty(object, object2, sessionImplementor);
        }
        if (this.isSame(object, object2, sessionImplementor.getEntityMode())) {
            return false;
        }
        Object object3 = this.getIdentifier(object, sessionImplementor);
        Object object4 = this.getIdentifier(object2, sessionImplementor);
        return this.getIdentifierType(sessionImplementor).isDirty(object3, object4, blArray, sessionImplementor);
    }
}

