/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.VersionType;
import org.hibernate.util.ComparableComparator;

public class LongType
extends PrimitiveType
implements DiscriminatorType,
VersionType {
    private static final Long ZERO = new Long(0L);

    public Serializable getDefaultValue() {
        return ZERO;
    }

    public Object get(ResultSet resultSet, String string) throws SQLException {
        return new Long(resultSet.getLong(string));
    }

    public Class getPrimitiveClass() {
        return Long.TYPE;
    }

    public Class getReturnedClass() {
        return Long.class;
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws SQLException {
        preparedStatement.setLong(n, (Long)object);
    }

    public int sqlType() {
        return -5;
    }

    public String getName() {
        return "long";
    }

    public Object stringToObject(String string) throws Exception {
        return new Long(string);
    }

    public Object next(Object object, SessionImplementor sessionImplementor) {
        return new Long((Long)object + 1L);
    }

    public Object seed(SessionImplementor sessionImplementor) {
        return ZERO;
    }

    public Comparator getComparator() {
        return ComparableComparator.INSTANCE;
    }

    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        return object.toString();
    }

    public Object fromStringValue(String string) {
        return new Long(string);
    }
}

