/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.VersionType;
import org.hibernate.util.ComparableComparator;

public class IntegerType
extends PrimitiveType
implements DiscriminatorType,
VersionType {
    private static final Integer ZERO = new Integer(0);

    public Serializable getDefaultValue() {
        return ZERO;
    }

    public Object get(ResultSet resultSet, String string) throws SQLException {
        return new Integer(resultSet.getInt(string));
    }

    public Class getPrimitiveClass() {
        return Integer.TYPE;
    }

    public Class getReturnedClass() {
        return Integer.class;
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws SQLException {
        preparedStatement.setInt(n, (Integer)object);
    }

    public int sqlType() {
        return 4;
    }

    public String getName() {
        return "integer";
    }

    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        return object.toString();
    }

    public Object stringToObject(String string) throws Exception {
        return new Integer(string);
    }

    public Object next(Object object, SessionImplementor sessionImplementor) {
        return new Integer((Integer)object + 1);
    }

    public Object seed(SessionImplementor sessionImplementor) {
        return ZERO;
    }

    public Comparator getComparator() {
        return ComparableComparator.INSTANCE;
    }

    public Object fromStringValue(String string) {
        return new Integer(string);
    }
}

