/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.PrimitiveType;

public class FloatType
extends PrimitiveType {
    public Serializable getDefaultValue() {
        return new Float(0.0);
    }

    public Object get(ResultSet resultSet, String string) throws SQLException {
        return new Float(resultSet.getFloat(string));
    }

    public Class getPrimitiveClass() {
        return Float.TYPE;
    }

    public Class getReturnedClass() {
        return Float.class;
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws SQLException {
        preparedStatement.setFloat(n, ((Float)object).floatValue());
    }

    public int sqlType() {
        return 6;
    }

    public String getName() {
        return "float";
    }

    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        return object.toString();
    }

    public Object fromStringValue(String string) {
        return new Float(string);
    }
}

