/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.PrimitiveType;

public class DoubleType
extends PrimitiveType {
    public Serializable getDefaultValue() {
        return new Double(0.0);
    }

    public Object get(ResultSet resultSet, String string) throws SQLException {
        return new Double(resultSet.getDouble(string));
    }

    public Class getPrimitiveClass() {
        return Double.TYPE;
    }

    public Class getReturnedClass() {
        return Double.class;
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws SQLException {
        preparedStatement.setDouble(n, (Double)object);
    }

    public int sqlType() {
        return 8;
    }

    public String getName() {
        return "double";
    }

    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        return object.toString();
    }

    public Object fromStringValue(String string) {
        return new Double(string);
    }
}

