/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.type.TimestampType;
import org.hibernate.type.VersionType;

public class DbTimestampType
extends TimestampType
implements VersionType {
    private static final Log log = LogFactory.getLog((Class)DbTimestampType.class);

    public String getName() {
        return "dbtimestamp";
    }

    public Object seed(SessionImplementor sessionImplementor) {
        if (sessionImplementor == null) {
            log.trace((Object)"incoming session was null; using current jvm time");
            return super.seed(sessionImplementor);
        }
        if (!sessionImplementor.getFactory().getDialect().supportsCurrentTimestampSelection()) {
            log.debug((Object)"falling back to vm-based timestamp, as dialect does not support current timestamp selection");
            return super.seed(sessionImplementor);
        }
        return this.getCurrentTimestamp(sessionImplementor);
    }

    private Timestamp getCurrentTimestamp(SessionImplementor sessionImplementor) {
        Dialect dialect = sessionImplementor.getFactory().getDialect();
        String string = dialect.getCurrentTimestampSelectString();
        if (dialect.isCurrentTimestampSelectStringCallable()) {
            return this.useCallableStatement(string, sessionImplementor);
        }
        return this.usePreparedStatement(string, sessionImplementor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Timestamp usePreparedStatement(String string, SessionImplementor sessionImplementor) {
        Timestamp timestamp;
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = sessionImplementor.getBatcher().prepareStatement(string);
                ResultSet resultSet = sessionImplementor.getBatcher().getResultSet(preparedStatement);
                resultSet.next();
                Timestamp timestamp2 = resultSet.getTimestamp(1);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("current timestamp retreived from db : " + timestamp2 + " (nanos=" + timestamp2.getNanos() + ", time=" + timestamp2.getTime() + ")"));
                }
                timestamp = timestamp2;
                Object var8_8 = null;
                if (preparedStatement == null) return timestamp;
            }
            catch (SQLException sQLException) {
                throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not select current db timestamp", string);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (preparedStatement == null) throw throwable;
            try {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
                throw throwable;
            }
            catch (SQLException sQLException2) {
                log.warn((Object)"unable to clean up prepared statement", (Throwable)sQLException2);
                throw throwable;
            }
        }
        try {}
        catch (SQLException sQLException) {
            log.warn((Object)"unable to clean up prepared statement", (Throwable)sQLException);
            return timestamp;
        }
        sessionImplementor.getBatcher().closeStatement(preparedStatement);
        return timestamp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Timestamp useCallableStatement(String string, SessionImplementor sessionImplementor) {
        Timestamp timestamp;
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = sessionImplementor.getBatcher().prepareCallableStatement(string);
                callableStatement.registerOutParameter(1, 93);
                callableStatement.execute();
                Timestamp timestamp2 = callableStatement.getTimestamp(1);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("current timestamp retreived from db : " + timestamp2 + " (nanos=" + timestamp2.getNanos() + ", time=" + timestamp2.getTime() + ")"));
                }
                timestamp = timestamp2;
                Object var7_7 = null;
                if (callableStatement == null) return timestamp;
            }
            catch (SQLException sQLException) {
                throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not call current db timestamp function", string);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (callableStatement == null) throw throwable;
            try {
                sessionImplementor.getBatcher().closeStatement(callableStatement);
                throw throwable;
            }
            catch (SQLException sQLException2) {
                log.warn((Object)"unable to clean up callable statement", (Throwable)sQLException2);
                throw throwable;
            }
        }
        try {}
        catch (SQLException sQLException) {
            log.warn((Object)"unable to clean up callable statement", (Throwable)sQLException);
            return timestamp;
        }
        sessionImplementor.getBatcher().closeStatement(callableStatement);
        return timestamp;
    }
}

