/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.IdentifierType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.MutableType;

public class DateType
extends MutableType
implements IdentifierType,
LiteralType {
    private static final String DATE_FORMAT = "dd MMMM yyyy";

    public Object get(ResultSet resultSet, String string) throws SQLException {
        return resultSet.getDate(string);
    }

    public Class getReturnedClass() {
        return Date.class;
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws SQLException {
        java.sql.Date date = object instanceof java.sql.Date ? (java.sql.Date)object : new java.sql.Date(((Date)object).getTime());
        preparedStatement.setDate(n, date);
    }

    public int sqlType() {
        return 91;
    }

    public boolean isEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Date date = (Date)object;
        Date date2 = (Date)object2;
        if (date.getTime() == date2.getTime()) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(date);
        calendar2.setTime(date2);
        return Hibernate.CALENDAR_DATE.isEqual(calendar, calendar2);
    }

    public int getHashCode(Object object, EntityMode entityMode) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)object);
        return Hibernate.CALENDAR_DATE.getHashCode(calendar, entityMode);
    }

    public String getName() {
        return "date";
    }

    public String toString(Object object) {
        return new SimpleDateFormat(DATE_FORMAT).format((Date)object);
    }

    public Object deepCopyNotNull(Object object) {
        return new java.sql.Date(((Date)object).getTime());
    }

    public Object stringToObject(String string) throws Exception {
        return DateFormat.getDateInstance().parse(string);
    }

    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        return '\'' + new java.sql.Date(((Date)object).getTime()).toString() + '\'';
    }

    public Object fromStringValue(String string) throws HibernateException {
        try {
            return new SimpleDateFormat(DATE_FORMAT).parse(string);
        }
        catch (ParseException parseException) {
            throw new HibernateException("could not parse XML", parseException);
        }
    }
}

