/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.ImmutableType;
import org.hibernate.type.LiteralType;

public class CurrencyType
extends ImmutableType
implements LiteralType {
    public static final Class CURRENCY_CLASS;
    private static final Method CURRENCY_GET_INSTANCE;
    private static final Method CURRENCY_GET_CODE;

    public Object get(ResultSet resultSet, String string) throws HibernateException, SQLException {
        String string2 = (String)Hibernate.STRING.nullSafeGet(resultSet, string);
        try {
            return string2 == null ? null : CURRENCY_GET_INSTANCE.invoke(null, string2);
        }
        catch (Exception exception) {
            throw new HibernateException("Could not resolve currency code: " + string2);
        }
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws HibernateException, SQLException {
        Object object2;
        try {
            object2 = CURRENCY_GET_CODE.invoke(object, null);
        }
        catch (Exception exception) {
            throw new HibernateException("Could not get Currency code", exception);
        }
        Hibernate.STRING.set(preparedStatement, object2, n);
    }

    public int sqlType() {
        return Hibernate.STRING.sqlType();
    }

    public String toString(Object object) throws HibernateException {
        try {
            return (String)CURRENCY_GET_CODE.invoke(object, null);
        }
        catch (Exception exception) {
            throw new HibernateException("Could not get Currency code", exception);
        }
    }

    public Class getReturnedClass() {
        return CURRENCY_CLASS;
    }

    public String getName() {
        return "currency";
    }

    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        String string;
        try {
            string = (String)CURRENCY_GET_CODE.invoke(object, null);
        }
        catch (Exception exception) {
            throw new HibernateException("Could not get Currency code", exception);
        }
        return ((LiteralType)((Object)Hibernate.STRING)).objectToSQLString(string, dialect);
    }

    public Object fromStringValue(String string) throws HibernateException {
        try {
            return CURRENCY_GET_INSTANCE.invoke(null, string);
        }
        catch (Exception exception) {
            throw new HibernateException("Could not resolve currency code: " + string);
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.util.Currency");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        if (clazz == null) {
            CURRENCY_CLASS = null;
            CURRENCY_GET_INSTANCE = null;
            CURRENCY_GET_CODE = null;
        } else {
            CURRENCY_CLASS = clazz;
            try {
                CURRENCY_GET_INSTANCE = clazz.getMethod("getInstance", String.class);
                CURRENCY_GET_CODE = clazz.getMethod("getCurrencyCode", new Class[0]);
            }
            catch (Exception exception) {
                throw new AssertionFailure("Exception in static initializer of CurrencyType", exception);
            }
        }
    }
}

