/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.AbstractType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.MarkerObject;

public abstract class CollectionType
extends AbstractType
implements AssociationType {
    private static final Object NOT_NULL_COLLECTION = new MarkerObject("NOT NULL COLLECTION");
    public static final Object UNFETCHED_COLLECTION = new MarkerObject("UNFETCHED COLLECTION");
    private final String role;
    private final String foreignKeyPropertyName;
    private final boolean isEmbeddedInXML;

    public CollectionType(String string, String string2, boolean bl) {
        this.role = string;
        this.foreignKeyPropertyName = string2;
        this.isEmbeddedInXML = bl;
    }

    public boolean isEmbeddedInXML() {
        return this.isEmbeddedInXML;
    }

    public String getRole() {
        return this.role;
    }

    public Object indexOf(Object object, Object object2) {
        throw new UnsupportedOperationException("generic collections don't have indexes");
    }

    public boolean contains(Object object, Object object2, SessionImplementor sessionImplementor) {
        Iterator iterator = this.getElementsIterator(object, sessionImplementor);
        while (iterator.hasNext()) {
            LazyInitializer lazyInitializer;
            Object object3 = iterator.next();
            if (object3 instanceof HibernateProxy && !(lazyInitializer = ((HibernateProxy)object3).getHibernateLazyInitializer()).isUninitialized()) {
                object3 = lazyInitializer.getImplementation();
            }
            if (object3 != object2) continue;
            return true;
        }
        return false;
    }

    public boolean isCollectionType() {
        return true;
    }

    public final boolean isEqual(Object object, Object object2, EntityMode entityMode) {
        return object == object2 || object instanceof PersistentCollection && ((PersistentCollection)object).isWrapper(object2) || object2 instanceof PersistentCollection && ((PersistentCollection)object2).isWrapper(object);
    }

    public int compare(Object object, Object object2, EntityMode entityMode) {
        return 0;
    }

    public int getHashCode(Object object, EntityMode entityMode) {
        throw new UnsupportedOperationException("cannot perform lookups on collections");
    }

    public abstract PersistentCollection instantiate(SessionImplementor var1, CollectionPersister var2, Serializable var3);

    public Object nullSafeGet(ResultSet resultSet, String string, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.nullSafeGet(resultSet, new String[]{string}, sessionImplementor, object);
    }

    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.resolve(null, sessionImplementor, object);
    }

    public final void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return ArrayHelper.EMPTY_INT_ARRAY;
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        return 0;
    }

    public String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        if (object == null) {
            return "null";
        }
        if (!Hibernate.isInitialized(object)) {
            return "<uninitialized>";
        }
        return this.renderLoggableString(object, sessionFactoryImplementor);
    }

    protected String renderLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        if (Element.class.isInstance(object)) {
            return ((Element)object).asXML();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Type type = this.getElementType(sessionFactoryImplementor);
        Iterator iterator = this.getElementsIterator(object);
        while (iterator.hasNext()) {
            arrayList.add(type.toLoggableString(iterator.next(), sessionFactoryImplementor));
        }
        return ((Object)arrayList).toString();
    }

    public Object deepCopy(Object object, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        return object;
    }

    public String getName() {
        return this.getReturnedClass().getName() + '(' + this.getRole() + ')';
    }

    public Iterator getElementsIterator(Object object, SessionImplementor sessionImplementor) {
        if (sessionImplementor.getEntityMode() == EntityMode.DOM4J) {
            SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
            CollectionPersister collectionPersister = sessionFactoryImplementor.getCollectionPersister(this.getRole());
            Type type = collectionPersister.getElementType();
            List list = ((Element)object).elements(collectionPersister.getElementNodeName());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < list.size(); ++i) {
                Element element = (Element)list.get(i);
                arrayList.add(type.fromXMLNode((Node)element, sessionFactoryImplementor));
            }
            return arrayList.iterator();
        }
        return this.getElementsIterator(object);
    }

    protected Iterator getElementsIterator(Object object) {
        return ((Collection)object).iterator();
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        Serializable serializable = this.getKeyOfOwner(object2, sessionImplementor);
        if (serializable == null) {
            return null;
        }
        return this.getPersister(sessionImplementor).getKeyType().disassemble(serializable, sessionImplementor, object2);
    }

    public Object assemble(Serializable serializable, SessionImplementor sessionImplementor, Object object) throws HibernateException {
        if (serializable == null) {
            return null;
        }
        Serializable serializable2 = (Serializable)this.getPersister(sessionImplementor).getKeyType().assemble(serializable, sessionImplementor, object);
        return this.resolveKey(serializable2, sessionImplementor, object);
    }

    private boolean isOwnerVersioned(SessionImplementor sessionImplementor) throws MappingException {
        return this.getPersister(sessionImplementor).getOwnerEntityPersister().isVersioned();
    }

    private CollectionPersister getPersister(SessionImplementor sessionImplementor) throws MappingException {
        return sessionImplementor.getFactory().getCollectionPersister(this.role);
    }

    public boolean isDirty(Object object, Object object2, SessionImplementor sessionImplementor) throws HibernateException {
        return this.isOwnerVersioned(sessionImplementor) && super.isDirty(object, object2, sessionImplementor);
    }

    public boolean isDirty(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException {
        return this.isDirty(object, object2, sessionImplementor);
    }

    public abstract PersistentCollection wrap(SessionImplementor var1, Object var2);

    public boolean isAssociationType() {
        return true;
    }

    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.FOREIGN_KEY_TO_PARENT;
    }

    public Serializable getKeyOfOwner(Object object, SessionImplementor sessionImplementor) {
        EntityEntry entityEntry = sessionImplementor.getPersistenceContext().getEntry(object);
        if (entityEntry == null) {
            return null;
        }
        if (this.foreignKeyPropertyName == null) {
            return entityEntry.getId();
        }
        Object object2 = entityEntry.getLoadedState() != null ? entityEntry.getLoadedValue(this.foreignKeyPropertyName) : entityEntry.getPersister().getPropertyValue(object, this.foreignKeyPropertyName, sessionImplementor.getEntityMode());
        Type type = this.getPersister(sessionImplementor).getKeyType();
        if (!type.getReturnedClass().isInstance(object2)) {
            object2 = (Serializable)type.semiResolve(entityEntry.getLoadedValue(this.foreignKeyPropertyName), sessionImplementor, object);
        }
        return (Serializable)object2;
    }

    public Object hydrate(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) {
        return NOT_NULL_COLLECTION;
    }

    public Object resolve(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        return this.resolveKey(this.getKeyOfOwner(object2, sessionImplementor), sessionImplementor, object2);
    }

    private Object resolveKey(Serializable serializable, SessionImplementor sessionImplementor, Object object) {
        return serializable == null ? null : this.getCollection(serializable, sessionImplementor, object);
    }

    public Object semiResolve(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        throw new UnsupportedOperationException("collection mappings may not form part of a property-ref");
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean useLHSPrimaryKey() {
        return this.foreignKeyPropertyName == null;
    }

    public String getRHSUniqueKeyPropertyName() {
        return null;
    }

    public Joinable getAssociatedJoinable(SessionFactoryImplementor sessionFactoryImplementor) throws MappingException {
        return (Joinable)((Object)sessionFactoryImplementor.getCollectionPersister(this.role));
    }

    public boolean isModified(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException {
        return false;
    }

    public String getAssociatedEntityName(SessionFactoryImplementor sessionFactoryImplementor) throws MappingException {
        try {
            QueryableCollection queryableCollection = (QueryableCollection)sessionFactoryImplementor.getCollectionPersister(this.role);
            if (!queryableCollection.getElementType().isEntityType()) {
                throw new MappingException("collection was not an association: " + queryableCollection.getRole());
            }
            return queryableCollection.getElementPersister().getEntityName();
        }
        catch (ClassCastException classCastException) {
            throw new MappingException("collection role is not queryable " + this.role);
        }
    }

    public Object replaceElements(Object object, Object object2, Object object3, Map map, SessionImplementor sessionImplementor) {
        Collection collection = (Collection)object2;
        collection.clear();
        Type type = this.getElementType(sessionImplementor.getFactory());
        Iterator iterator = ((Collection)object).iterator();
        while (iterator.hasNext()) {
            collection.add(type.replace(iterator.next(), null, sessionImplementor, object3, map));
        }
        if (object instanceof PersistentCollection && collection instanceof PersistentCollection && !((PersistentCollection)object).isDirty()) {
            ((PersistentCollection)((Object)collection)).clearDirty();
        }
        return collection;
    }

    protected Object instantiateResult(Object object) {
        return this.instantiate(-1);
    }

    public abstract Object instantiate(int var1);

    public Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3, Map map) throws HibernateException {
        if (object == null) {
            return null;
        }
        if (!Hibernate.isInitialized(object)) {
            return object2;
        }
        Object object4 = object2 == null || object2 == object ? this.instantiateResult(object) : object2;
        object4 = this.replaceElements(object, object4, object3, map, sessionImplementor);
        if (object == object2) {
            this.replaceElements(object4, object2, object3, map, sessionImplementor);
            object4 = object2;
        }
        return object4;
    }

    public final Type getElementType(SessionFactoryImplementor sessionFactoryImplementor) throws MappingException {
        return sessionFactoryImplementor.getCollectionPersister(this.getRole()).getElementType();
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getRole() + ')';
    }

    public String getOnCondition(String string, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        return this.getAssociatedJoinable(sessionFactoryImplementor).filterFragment(string, map);
    }

    public Object getCollection(Serializable serializable, SessionImplementor sessionImplementor, Object object) {
        CollectionPersister collectionPersister = this.getPersister(sessionImplementor);
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        EntityMode entityMode = sessionImplementor.getEntityMode();
        if (entityMode == EntityMode.DOM4J && !this.isEmbeddedInXML) {
            return UNFETCHED_COLLECTION;
        }
        PersistentCollection persistentCollection = persistenceContext.getLoadContexts().locateLoadingCollection(collectionPersister, serializable);
        if (persistentCollection == null && (persistentCollection = persistenceContext.useUnownedCollection(new CollectionKey(collectionPersister, serializable, entityMode))) == null) {
            persistentCollection = this.instantiate(sessionImplementor, collectionPersister, serializable);
            persistentCollection.setOwner(object);
            persistenceContext.addUninitializedCollection(collectionPersister, persistentCollection, serializable);
            if (this.initializeImmediately(entityMode)) {
                sessionImplementor.initializeCollection(persistentCollection, false);
            } else if (!collectionPersister.isLazy()) {
                persistenceContext.addNonLazyCollection(persistentCollection);
            }
            if (this.hasHolder(entityMode)) {
                sessionImplementor.getPersistenceContext().addCollectionHolder(persistentCollection);
            }
        }
        persistentCollection.setOwner(object);
        return persistentCollection.getValue();
    }

    public boolean hasHolder(EntityMode entityMode) {
        return entityMode == EntityMode.DOM4J;
    }

    protected boolean initializeImmediately(EntityMode entityMode) {
        return entityMode == EntityMode.DOM4J;
    }

    public String getLHSPropertyName() {
        return this.foreignKeyPropertyName;
    }

    public boolean isXMLElement() {
        return true;
    }

    public Object fromXMLNode(Node node, Mapping mapping) throws HibernateException {
        return node;
    }

    public void setToXMLNode(Node node, Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        if (!this.isEmbeddedInXML) {
            node.detach();
        } else {
            CollectionType.replaceNode(node, (Element)object);
        }
    }

    public boolean isAlwaysDirtyChecked() {
        return true;
    }

    public boolean[] toColumnNullness(Object object, Mapping mapping) {
        return ArrayHelper.EMPTY_BOOLEAN_ARRAY;
    }
}

