/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.lob.ClobImpl;
import org.hibernate.lob.SerializableClob;
import org.hibernate.type.AbstractType;
import org.hibernate.util.ArrayHelper;

public class ClobType
extends AbstractType {
    public void set(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (object == null) {
            preparedStatement.setNull(n, 2005);
        } else {
            boolean bl;
            if (object instanceof SerializableClob) {
                object = ((SerializableClob)object).getWrappedClob();
            }
            boolean bl2 = bl = sessionImplementor.getFactory().getDialect().useInputStreamToInsertBlob() && object instanceof ClobImpl;
            if (bl) {
                ClobImpl clobImpl = (ClobImpl)object;
                preparedStatement.setCharacterStream(n, clobImpl.getCharacterStream(), (int)clobImpl.length());
            } else {
                preparedStatement.setClob(n, (Clob)object);
            }
        }
    }

    public Object get(ResultSet resultSet, String string) throws HibernateException, SQLException {
        Clob clob = resultSet.getClob(string);
        return resultSet.wasNull() ? null : new SerializableClob(clob);
    }

    public Class getReturnedClass() {
        return Clob.class;
    }

    public boolean isEqual(Object object, Object object2, EntityMode entityMode) {
        return object == object2;
    }

    public int getHashCode(Object object, EntityMode entityMode) {
        return System.identityHashCode(object);
    }

    public int compare(Object object, Object object2, EntityMode entityMode) {
        return 0;
    }

    public String getName() {
        return "clob";
    }

    public Serializable disassemble(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        throw new UnsupportedOperationException("Clobs are not cacheable");
    }

    public Object deepCopy(Object object, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) {
        return object;
    }

    public Object fromXMLNode(Node node, Mapping mapping) {
        return Hibernate.createClob(node.getText());
    }

    public int getColumnSpan(Mapping mapping) {
        return 1;
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet resultSet, String string, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.get(resultSet, string);
    }

    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.get(resultSet, stringArray[0]);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (blArray[0]) {
            this.set(preparedStatement, object, n, sessionImplementor);
        }
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        this.set(preparedStatement, object, n, sessionImplementor);
    }

    public Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3, Map map) throws HibernateException {
        return object2;
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return new int[]{2005};
    }

    public void setToXMLNode(Node node, Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        if (object != null) {
            Clob clob = (Clob)object;
            try {
                int n = (int)clob.length();
                node.setText(clob.getSubString(0L, n));
            }
            catch (SQLException sQLException) {
                throw new HibernateException("could not read XML from Clob", sQLException);
            }
        }
    }

    public String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        return object == null ? "null" : object.toString();
    }

    public boolean[] toColumnNullness(Object object, Mapping mapping) {
        return object == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }

    public boolean isDirty(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException {
        return blArray[0] && this.isDirty(object, object2, sessionImplementor);
    }
}

