/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;

public class CharacterType
extends PrimitiveType
implements DiscriminatorType {
    public Serializable getDefaultValue() {
        throw new UnsupportedOperationException("not a valid id type");
    }

    public Object get(ResultSet resultSet, String string) throws SQLException {
        String string2 = resultSet.getString(string);
        if (string2 == null) {
            return null;
        }
        return new Character(string2.charAt(0));
    }

    public Class getPrimitiveClass() {
        return Character.TYPE;
    }

    public Class getReturnedClass() {
        return Character.class;
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws SQLException {
        preparedStatement.setString(n, object.toString());
    }

    public int sqlType() {
        return 1;
    }

    public String getName() {
        return "character";
    }

    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        return '\'' + object.toString() + '\'';
    }

    public Object stringToObject(String string) throws Exception {
        if (string.length() != 1) {
            throw new MappingException("multiple or zero characters found parsing string");
        }
        return new Character(string.charAt(0));
    }

    public Object fromStringValue(String string) {
        return new Character(string.charAt(0));
    }
}

