/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.BooleanType;

public abstract class CharBooleanType
extends BooleanType {
    protected abstract String getTrueString();

    protected abstract String getFalseString();

    public Object get(ResultSet resultSet, String string) throws SQLException {
        String string2 = resultSet.getString(string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return this.getTrueString().equalsIgnoreCase(string2.trim()) ? Boolean.TRUE : Boolean.FALSE;
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws SQLException {
        preparedStatement.setString(n, this.toCharacter(object));
    }

    public int sqlType() {
        return 1;
    }

    private String toCharacter(Object object) {
        return (Boolean)object != false ? this.getTrueString() : this.getFalseString();
    }

    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        return "'" + this.toCharacter(object) + "'";
    }

    public Object stringToObject(String string) throws Exception {
        if (this.getTrueString().equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if (this.getFalseString().equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        throw new HibernateException("Could not interpret: " + string);
    }
}

