/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.MutableType;
import org.hibernate.type.VersionType;
import org.hibernate.util.CalendarComparator;

public class CalendarType
extends MutableType
implements VersionType {
    public Object get(ResultSet resultSet, String string) throws HibernateException, SQLException {
        Timestamp timestamp = resultSet.getTimestamp(string);
        if (timestamp != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            if (Environment.jvmHasTimestampBug()) {
                gregorianCalendar.setTime(new Date(timestamp.getTime() + (long)(timestamp.getNanos() / 1000000)));
            } else {
                gregorianCalendar.setTime(timestamp);
            }
            return gregorianCalendar;
        }
        return null;
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws HibernateException, SQLException {
        Calendar calendar = (Calendar)object;
        preparedStatement.setTimestamp(n, new Timestamp(calendar.getTime().getTime()), calendar);
    }

    public int sqlType() {
        return 93;
    }

    public String toString(Object object) throws HibernateException {
        return Hibernate.TIMESTAMP.toString(((Calendar)object).getTime());
    }

    public Object fromStringValue(String string) throws HibernateException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime((Date)Hibernate.TIMESTAMP.fromStringValue(string));
        return gregorianCalendar;
    }

    public Object deepCopyNotNull(Object object) throws HibernateException {
        return ((Calendar)object).clone();
    }

    public Class getReturnedClass() {
        return Calendar.class;
    }

    public int compare(Object object, Object object2, EntityMode entityMode) {
        return CalendarComparator.INSTANCE.compare(object, object2);
    }

    public boolean isEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Calendar calendar = (Calendar)object;
        Calendar calendar2 = (Calendar)object2;
        return calendar.get(14) == calendar2.get(14) && calendar.get(13) == calendar2.get(13) && calendar.get(12) == calendar2.get(12) && calendar.get(11) == calendar2.get(11) && calendar.get(5) == calendar2.get(5) && calendar.get(2) == calendar2.get(2) && calendar.get(1) == calendar2.get(1);
    }

    public int getHashCode(Object object, EntityMode entityMode) {
        Calendar calendar = (Calendar)object;
        int n = 1;
        n = 31 * n + calendar.get(14);
        n = 31 * n + calendar.get(13);
        n = 31 * n + calendar.get(12);
        n = 31 * n + calendar.get(11);
        n = 31 * n + calendar.get(5);
        n = 31 * n + calendar.get(2);
        n = 31 * n + calendar.get(1);
        return n;
    }

    public String getName() {
        return "calendar";
    }

    public Object next(Object object, SessionImplementor sessionImplementor) {
        return this.seed(sessionImplementor);
    }

    public Object seed(SessionImplementor sessionImplementor) {
        return Calendar.getInstance();
    }

    public Comparator getComparator() {
        return CalendarComparator.INSTANCE;
    }
}

