/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.type.MutableType;
import org.hibernate.util.CalendarComparator;

public class CalendarDateType
extends MutableType {
    public Object get(ResultSet resultSet, String string) throws HibernateException, SQLException {
        java.sql.Date date = resultSet.getDate(string);
        if (date != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            return gregorianCalendar;
        }
        return null;
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws HibernateException, SQLException {
        Calendar calendar = (Calendar)object;
        preparedStatement.setDate(n, new java.sql.Date(calendar.getTime().getTime()), calendar);
    }

    public int sqlType() {
        return 91;
    }

    public String toString(Object object) throws HibernateException {
        return Hibernate.DATE.toString(((Calendar)object).getTime());
    }

    public Object fromStringValue(String string) throws HibernateException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime((Date)Hibernate.DATE.fromStringValue(string));
        return gregorianCalendar;
    }

    public Object deepCopyNotNull(Object object) {
        return ((Calendar)object).clone();
    }

    public Class getReturnedClass() {
        return Calendar.class;
    }

    public int compare(Object object, Object object2, EntityMode entityMode) {
        return CalendarComparator.INSTANCE.compare(object, object2);
    }

    public boolean isEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Calendar calendar = (Calendar)object;
        Calendar calendar2 = (Calendar)object2;
        return calendar.get(5) == calendar2.get(5) && calendar.get(2) == calendar2.get(2) && calendar.get(1) == calendar2.get(1);
    }

    public int getHashCode(Object object, EntityMode entityMode) {
        Calendar calendar = (Calendar)object;
        int n = 1;
        n = 31 * n + calendar.get(5);
        n = 31 * n + calendar.get(2);
        n = 31 * n + calendar.get(1);
        return n;
    }

    public String getName() {
        return "calendar_date";
    }
}

