/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.VersionType;
import org.hibernate.util.ComparableComparator;

public class ByteType
extends PrimitiveType
implements DiscriminatorType,
VersionType {
    private static final Byte ZERO = new Byte(0);

    public Serializable getDefaultValue() {
        return ZERO;
    }

    public Object get(ResultSet resultSet, String string) throws SQLException {
        return new Byte(resultSet.getByte(string));
    }

    public Class getPrimitiveClass() {
        return Byte.TYPE;
    }

    public Class getReturnedClass() {
        return Byte.class;
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws SQLException {
        preparedStatement.setByte(n, (Byte)object);
    }

    public int sqlType() {
        return -6;
    }

    public String getName() {
        return "byte";
    }

    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        return object.toString();
    }

    public Object stringToObject(String string) throws Exception {
        return new Byte(string);
    }

    public Object fromStringValue(String string) {
        return new Byte(string);
    }

    public Object next(Object object, SessionImplementor sessionImplementor) {
        return new Byte((byte)((Byte)object + 1));
    }

    public Object seed(SessionImplementor sessionImplementor) {
        return ZERO;
    }

    public Comparator getComparator() {
        return ComparableComparator.INSTANCE;
    }
}

