/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;

public class BooleanType
extends PrimitiveType
implements DiscriminatorType {
    public Serializable getDefaultValue() {
        return Boolean.FALSE;
    }

    public Object get(ResultSet resultSet, String string) throws SQLException {
        return resultSet.getBoolean(string) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Class getPrimitiveClass() {
        return Boolean.TYPE;
    }

    public Class getReturnedClass() {
        return Boolean.class;
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws SQLException {
        preparedStatement.setBoolean(n, (Boolean)object);
    }

    public int sqlType() {
        return -7;
    }

    public String getName() {
        return "boolean";
    }

    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        return dialect.toBooleanValueString((Boolean)object);
    }

    public Object stringToObject(String string) throws Exception {
        return this.fromStringValue(string);
    }

    public Object fromStringValue(String string) {
        return Boolean.valueOf(string);
    }
}

