/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.lob.BlobImpl;
import org.hibernate.lob.SerializableBlob;
import org.hibernate.type.AbstractType;
import org.hibernate.util.ArrayHelper;

public class BlobType
extends AbstractType {
    public void set(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (object == null) {
            preparedStatement.setNull(n, 2004);
        } else {
            boolean bl;
            if (object instanceof SerializableBlob) {
                object = ((SerializableBlob)object).getWrappedBlob();
            }
            boolean bl2 = bl = sessionImplementor.getFactory().getDialect().useInputStreamToInsertBlob() && object instanceof BlobImpl;
            if (bl) {
                BlobImpl blobImpl = (BlobImpl)object;
                preparedStatement.setBinaryStream(n, blobImpl.getBinaryStream(), (int)blobImpl.length());
            } else {
                preparedStatement.setBlob(n, (Blob)object);
            }
        }
    }

    public Object get(ResultSet resultSet, String string) throws HibernateException, SQLException {
        Blob blob = resultSet.getBlob(string);
        return resultSet.wasNull() ? null : new SerializableBlob(blob);
    }

    public Class getReturnedClass() {
        return Blob.class;
    }

    public boolean isEqual(Object object, Object object2, EntityMode entityMode) {
        return object == object2;
    }

    public int getHashCode(Object object, EntityMode entityMode) {
        return System.identityHashCode(object);
    }

    public int compare(Object object, Object object2, EntityMode entityMode) {
        return 0;
    }

    public String getName() {
        return "blob";
    }

    public Serializable disassemble(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        throw new UnsupportedOperationException("Blobs are not cacheable");
    }

    public Object deepCopy(Object object, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) {
        return object;
    }

    public Object fromXMLNode(Node node, Mapping mapping) {
        throw new UnsupportedOperationException("todo");
    }

    public int getColumnSpan(Mapping mapping) {
        return 1;
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet resultSet, String string, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.get(resultSet, string);
    }

    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.get(resultSet, stringArray[0]);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (blArray[0]) {
            this.set(preparedStatement, object, n, sessionImplementor);
        }
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        this.set(preparedStatement, object, n, sessionImplementor);
    }

    public Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3, Map map) throws HibernateException {
        return object2;
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return new int[]{2004};
    }

    public void setToXMLNode(Node node, Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        throw new UnsupportedOperationException("todo");
    }

    public String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        return object == null ? "null" : object.toString();
    }

    public boolean[] toColumnNullness(Object object, Mapping mapping) {
        return object == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }

    public boolean isDirty(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException {
        return blArray[0] && this.isDirty(object, object2, sessionImplementor);
    }
}

