/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.ImmutableType;

public class BigIntegerType
extends ImmutableType
implements DiscriminatorType {
    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        return object.toString();
    }

    public Object stringToObject(String string) throws Exception {
        return new BigInteger(string);
    }

    public Object get(ResultSet resultSet, String string) throws HibernateException, SQLException {
        BigDecimal bigDecimal = resultSet.getBigDecimal(string);
        return bigDecimal == null ? null : bigDecimal.setScale(0, 7).unscaledValue();
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws HibernateException, SQLException {
        preparedStatement.setBigDecimal(n, new BigDecimal((BigInteger)object));
    }

    public int sqlType() {
        return 2;
    }

    public String toString(Object object) throws HibernateException {
        return object.toString();
    }

    public Class getReturnedClass() {
        return BigInteger.class;
    }

    public boolean isEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && ((BigInteger)object).compareTo((BigInteger)object2) == 0;
    }

    public int getHashCode(Object object, EntityMode entityMode) {
        return ((BigInteger)object).intValue();
    }

    public String getName() {
        return "big_integer";
    }

    public Object fromStringValue(String string) {
        return new BigInteger(string);
    }
}

