/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.EntityModeToTuplizerMapping;
import org.hibernate.tuple.entity.Dom4jEntityTuplizer;
import org.hibernate.tuple.entity.DynamicMapEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.tuple.entity.PojoEntityTuplizer;
import org.hibernate.util.ReflectHelper;

public class EntityEntityModeToTuplizerMapping
extends EntityModeToTuplizerMapping
implements Serializable {
    private static final Class[] ENTITY_TUP_CTOR_SIG = new Class[]{EntityMetamodel.class, PersistentClass.class};

    public EntityEntityModeToTuplizerMapping(PersistentClass persistentClass, EntityMetamodel entityMetamodel) {
        HashMap hashMap = new HashMap();
        if (persistentClass.getTuplizerMap() != null) {
            hashMap.putAll(persistentClass.getTuplizerMap());
        }
        EntityTuplizer entityTuplizer = null;
        String string = (String)hashMap.remove(EntityMode.MAP);
        entityTuplizer = string == null ? new DynamicMapEntityTuplizer(entityMetamodel, persistentClass) : EntityEntityModeToTuplizerMapping.buildEntityTuplizer(string, persistentClass, entityMetamodel);
        EntityTuplizer entityTuplizer2 = null;
        string = (String)hashMap.remove(EntityMode.POJO);
        entityTuplizer2 = persistentClass.hasPojoRepresentation() ? (string == null ? new PojoEntityTuplizer(entityMetamodel, persistentClass) : EntityEntityModeToTuplizerMapping.buildEntityTuplizer(string, persistentClass, entityMetamodel)) : entityTuplizer;
        EntityTuplizer entityTuplizer3 = null;
        string = (String)hashMap.remove(EntityMode.DOM4J);
        entityTuplizer3 = persistentClass.hasDom4jRepresentation() ? (string == null ? new Dom4jEntityTuplizer(entityMetamodel, persistentClass) : EntityEntityModeToTuplizerMapping.buildEntityTuplizer(string, persistentClass, entityMetamodel)) : null;
        if (entityTuplizer2 != null) {
            this.addTuplizer(EntityMode.POJO, entityTuplizer2);
        }
        if (entityTuplizer != null) {
            this.addTuplizer(EntityMode.MAP, entityTuplizer);
        }
        if (entityTuplizer3 != null) {
            this.addTuplizer(EntityMode.DOM4J, entityTuplizer3);
        }
        if (!hashMap.isEmpty()) {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                EntityMode entityMode = (EntityMode)entry.getKey();
                EntityTuplizer entityTuplizer4 = EntityEntityModeToTuplizerMapping.buildEntityTuplizer((String)entry.getValue(), persistentClass, entityMetamodel);
                this.addTuplizer(entityMode, entityTuplizer4);
            }
        }
    }

    private static EntityTuplizer buildEntityTuplizer(String string, PersistentClass persistentClass, EntityMetamodel entityMetamodel) {
        try {
            Class clazz = ReflectHelper.classForName(string);
            return (EntityTuplizer)clazz.getConstructor(ENTITY_TUP_CTOR_SIG).newInstance(entityMetamodel, persistentClass);
        }
        catch (Throwable throwable) {
            throw new HibernateException("Could not build tuplizer [" + string + "]", throwable);
        }
    }
}

