/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.map.MapProxyFactory;
import org.hibernate.tuple.DynamicMapInstantiator;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.entity.AbstractEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;

public class DynamicMapEntityTuplizer
extends AbstractEntityTuplizer {
    static final Log log = LogFactory.getLog((Class)DynamicMapEntityTuplizer.class);

    DynamicMapEntityTuplizer(EntityMetamodel entityMetamodel, PersistentClass persistentClass) {
        super(entityMetamodel, persistentClass);
    }

    public EntityMode getEntityMode() {
        return EntityMode.MAP;
    }

    private PropertyAccessor buildPropertyAccessor(Property property) {
        if (property.isBackRef()) {
            return property.getPropertyAccessor(null);
        }
        return PropertyAccessorFactory.getDynamicMapPropertyAccessor();
    }

    protected Getter buildPropertyGetter(Property property, PersistentClass persistentClass) {
        return this.buildPropertyAccessor(property).getGetter(null, property.getName());
    }

    protected Setter buildPropertySetter(Property property, PersistentClass persistentClass) {
        return this.buildPropertyAccessor(property).getSetter(null, property.getName());
    }

    protected Instantiator buildInstantiator(PersistentClass persistentClass) {
        return new DynamicMapInstantiator(persistentClass);
    }

    protected ProxyFactory buildProxyFactory(PersistentClass persistentClass, Getter getter, Setter setter) {
        MapProxyFactory mapProxyFactory = new MapProxyFactory();
        try {
            mapProxyFactory.postInstantiate(this.getEntityName(), null, null, null, null, null);
        }
        catch (HibernateException hibernateException) {
            log.warn((Object)("could not create proxy factory for:" + this.getEntityName()), (Throwable)hibernateException);
            mapProxyFactory = null;
        }
        return mapProxyFactory;
    }

    public Class getMappedClass() {
        return Map.class;
    }

    public Class getConcreteProxyClass() {
        return Map.class;
    }

    public boolean isInstrumented() {
        return false;
    }
}

