/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.dom4j.Dom4jProxyFactory;
import org.hibernate.tuple.Dom4jInstantiator;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.entity.AbstractEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.AbstractComponentType;

public class Dom4jEntityTuplizer
extends AbstractEntityTuplizer {
    static final Log log = LogFactory.getLog((Class)Dom4jEntityTuplizer.class);
    private Set subclassNodeNames = new HashSet();

    Dom4jEntityTuplizer(EntityMetamodel entityMetamodel, PersistentClass persistentClass) {
        super(entityMetamodel, persistentClass);
        Iterator iterator = persistentClass.getSubclassClosureIterator();
        while (iterator.hasNext()) {
            PersistentClass persistentClass2 = (PersistentClass)iterator.next();
            this.subclassNodeNames.add(persistentClass2.getNodeName());
        }
    }

    public EntityMode getEntityMode() {
        return EntityMode.DOM4J;
    }

    private PropertyAccessor buildPropertyAccessor(Property property) {
        if (property.isBackRef()) {
            return property.getPropertyAccessor(null);
        }
        return PropertyAccessorFactory.getDom4jPropertyAccessor(property.getNodeName(), property.getType(), this.getEntityMetamodel().getSessionFactory());
    }

    protected Getter buildPropertyGetter(Property property, PersistentClass persistentClass) {
        return this.buildPropertyAccessor(property).getGetter(null, property.getName());
    }

    protected Setter buildPropertySetter(Property property, PersistentClass persistentClass) {
        return this.buildPropertyAccessor(property).getSetter(null, property.getName());
    }

    protected Instantiator buildInstantiator(PersistentClass persistentClass) {
        return new Dom4jInstantiator(persistentClass);
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        if (object instanceof Element) {
            return super.getIdentifier(object);
        }
        return (Serializable)object;
    }

    protected ProxyFactory buildProxyFactory(PersistentClass persistentClass, Getter getter, Setter setter) {
        HashSet<Class> hashSet = new HashSet<Class>();
        hashSet.add(HibernateProxy.class);
        hashSet.add(Element.class);
        Dom4jProxyFactory dom4jProxyFactory = new Dom4jProxyFactory();
        try {
            dom4jProxyFactory.postInstantiate(this.getEntityName(), Element.class, hashSet, null, null, persistentClass.hasEmbeddedIdentifier() ? (AbstractComponentType)persistentClass.getIdentifier().getType() : null);
        }
        catch (HibernateException hibernateException) {
            log.warn((Object)("could not create proxy factory for:" + this.getEntityName()), (Throwable)hibernateException);
            dom4jProxyFactory = null;
        }
        return dom4jProxyFactory;
    }

    public Class getMappedClass() {
        return Element.class;
    }

    public Class getConcreteProxyClass() {
        return Element.class;
    }

    public boolean isInstrumented() {
        return false;
    }
}

