/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.Assigned;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.tuple.VersionProperty;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.ComponentType;

public abstract class AbstractEntityTuplizer
implements EntityTuplizer {
    private final EntityMetamodel entityMetamodel;
    private final Getter idGetter;
    private final Setter idSetter;
    protected final Getter[] getters;
    protected final Setter[] setters;
    protected final int propertySpan;
    protected final boolean hasCustomAccessors;
    private final Instantiator instantiator;
    private final ProxyFactory proxyFactory;
    private final AbstractComponentType identifierMapperType;

    protected abstract EntityMode getEntityMode();

    protected abstract Getter buildPropertyGetter(Property var1, PersistentClass var2);

    protected abstract Setter buildPropertySetter(Property var1, PersistentClass var2);

    protected abstract Instantiator buildInstantiator(PersistentClass var1);

    protected abstract ProxyFactory buildProxyFactory(PersistentClass var1, Getter var2, Setter var3);

    public AbstractEntityTuplizer(EntityMetamodel entityMetamodel, PersistentClass persistentClass) {
        MetaAttributable metaAttributable;
        this.entityMetamodel = entityMetamodel;
        if (!entityMetamodel.getIdentifierProperty().isVirtual()) {
            this.idGetter = this.buildPropertyGetter(persistentClass.getIdentifierProperty(), persistentClass);
            this.idSetter = this.buildPropertySetter(persistentClass.getIdentifierProperty(), persistentClass);
        } else {
            this.idGetter = null;
            this.idSetter = null;
        }
        this.propertySpan = entityMetamodel.getPropertySpan();
        this.getters = new Getter[this.propertySpan];
        this.setters = new Setter[this.propertySpan];
        Iterator iterator = persistentClass.getPropertyClosureIterator();
        boolean bl = false;
        int n = 0;
        while (iterator.hasNext()) {
            metaAttributable = (Property)iterator.next();
            this.getters[n] = this.buildPropertyGetter((Property)metaAttributable, persistentClass);
            this.setters[n] = this.buildPropertySetter((Property)metaAttributable, persistentClass);
            if (!((Property)metaAttributable).isBasicPropertyAccessor()) {
                bl = true;
            }
            ++n;
        }
        this.hasCustomAccessors = bl;
        this.instantiator = this.buildInstantiator(persistentClass);
        if (entityMetamodel.isLazy()) {
            this.proxyFactory = this.buildProxyFactory(persistentClass, this.idGetter, this.idSetter);
            if (this.proxyFactory == null) {
                entityMetamodel.setLazy(false);
            }
        } else {
            this.proxyFactory = null;
        }
        this.identifierMapperType = (metaAttributable = persistentClass.getIdentifierMapper()) == null ? null : (AbstractComponentType)((Component)metaAttributable).getType();
    }

    protected String getEntityName() {
        return this.entityMetamodel.getName();
    }

    protected Set getSubclassEntityNames() {
        return this.entityMetamodel.getSubclassEntityNames();
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        Object object2;
        if (this.entityMetamodel.getIdentifierProperty().isEmbedded()) {
            object2 = object;
        } else if (this.idGetter == null) {
            if (this.identifierMapperType == null) {
                throw new HibernateException("The class has no identifier property: " + this.getEntityName());
            }
            ComponentType componentType = (ComponentType)this.entityMetamodel.getIdentifierProperty().getType();
            object2 = componentType.instantiate(this.getEntityMode());
            componentType.setPropertyValues(object2, this.identifierMapperType.getPropertyValues(object, this.getEntityMode()), this.getEntityMode());
        } else {
            object2 = this.idGetter.get(object);
        }
        try {
            return (Serializable)object2;
        }
        catch (ClassCastException classCastException) {
            StringBuffer stringBuffer = new StringBuffer("Identifier classes must be serializable. ");
            if (object2 != null) {
                stringBuffer.append(object2.getClass().getName() + " is not serializable. ");
            }
            if (classCastException.getMessage() != null) {
                stringBuffer.append(classCastException.getMessage());
            }
            throw new ClassCastException(stringBuffer.toString());
        }
    }

    public void setIdentifier(Object object, Serializable serializable) throws HibernateException {
        if (this.entityMetamodel.getIdentifierProperty().isEmbedded()) {
            if (object != serializable) {
                AbstractComponentType abstractComponentType = (AbstractComponentType)this.entityMetamodel.getIdentifierProperty().getType();
                abstractComponentType.setPropertyValues(object, abstractComponentType.getPropertyValues((Object)serializable, this.getEntityMode()), this.getEntityMode());
            }
        } else if (this.idSetter != null) {
            this.idSetter.set(object, serializable, this.getFactory());
        }
    }

    public void resetIdentifier(Object object, Serializable serializable, Object object2) {
        if (!(this.entityMetamodel.getIdentifierProperty().getIdentifierGenerator() instanceof Assigned)) {
            Serializable serializable2 = this.entityMetamodel.getIdentifierProperty().getUnsavedValue().getDefaultValue(serializable);
            this.setIdentifier(object, serializable2);
            VersionProperty versionProperty = this.entityMetamodel.getVersionProperty();
            if (this.entityMetamodel.isVersioned()) {
                this.setPropertyValue(object, this.entityMetamodel.getVersionPropertyIndex(), versionProperty.getUnsavedValue().getDefaultValue(object2));
            }
        }
    }

    public Object getVersion(Object object) throws HibernateException {
        if (!this.entityMetamodel.isVersioned()) {
            return null;
        }
        return this.getters[this.entityMetamodel.getVersionPropertyIndex()].get(object);
    }

    protected boolean shouldGetAllProperties(Object object) {
        return !this.hasUninitializedLazyProperties(object);
    }

    public Object[] getPropertyValues(Object object) throws HibernateException {
        boolean bl = this.shouldGetAllProperties(object);
        int n = this.entityMetamodel.getPropertySpan();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            StandardProperty standardProperty = this.entityMetamodel.getProperties()[i];
            objectArray[i] = bl || !standardProperty.isLazy() ? this.getters[i].get(object) : LazyPropertyInitializer.UNFETCHED_PROPERTY;
        }
        return objectArray;
    }

    public Object[] getPropertyValuesToInsert(Object object, Map map, SessionImplementor sessionImplementor) throws HibernateException {
        int n = this.entityMetamodel.getPropertySpan();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.getters[i].getForInsert(object, map, sessionImplementor);
        }
        return objectArray;
    }

    public Object getPropertyValue(Object object, int n) throws HibernateException {
        return this.getters[n].get(object);
    }

    public Object getPropertyValue(Object object, String string) throws HibernateException {
        int n = string.indexOf(46);
        String string2 = n > 0 ? string.substring(0, n) : string;
        int n2 = this.entityMetamodel.getPropertyIndex(string2);
        Object object2 = this.getPropertyValue(object, n2);
        if (n > 0) {
            ComponentType componentType = (ComponentType)this.entityMetamodel.getPropertyTypes()[n2];
            return this.getComponentValue(componentType, object2, string.substring(n + 1));
        }
        return object2;
    }

    protected Object getComponentValue(ComponentType componentType, Object object, String string) {
        int n;
        int n2 = string.indexOf(46);
        String string2 = n2 > 0 ? string.substring(0, n2) : string;
        String[] stringArray = componentType.getPropertyNames();
        for (n = 0; n < stringArray.length && !string2.equals(stringArray[n]); ++n) {
        }
        if (n == stringArray.length) {
            throw new MappingException("component property not found: " + string2);
        }
        Object object2 = componentType.getPropertyValue(object, n, this.getEntityMode());
        if (n2 > 0) {
            ComponentType componentType2 = (ComponentType)componentType.getSubtypes()[n];
            return this.getComponentValue(componentType2, object2, string.substring(n2 + 1));
        }
        return object2;
    }

    public void setPropertyValues(Object object, Object[] objectArray) throws HibernateException {
        boolean bl = !this.entityMetamodel.hasLazyProperties();
        for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
            if (!bl && objectArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY) continue;
            this.setters[i].set(object, objectArray[i], this.getFactory());
        }
    }

    public void setPropertyValue(Object object, int n, Object object2) throws HibernateException {
        this.setters[n].set(object, object2, this.getFactory());
    }

    public void setPropertyValue(Object object, String string, Object object2) throws HibernateException {
        this.setters[this.entityMetamodel.getPropertyIndex(string)].set(object, object2, this.getFactory());
    }

    public final Object instantiate(Serializable serializable) throws HibernateException {
        Object object = this.getInstantiator().instantiate(serializable);
        if (serializable != null) {
            this.setIdentifier(object, serializable);
        }
        return object;
    }

    public final Object instantiate() throws HibernateException {
        return this.instantiate(null);
    }

    public void afterInitialize(Object object, boolean bl, SessionImplementor sessionImplementor) {
    }

    public boolean hasUninitializedLazyProperties(Object object) {
        return false;
    }

    public final boolean isInstance(Object object) {
        return this.getInstantiator().isInstance(object);
    }

    public boolean hasProxy() {
        return this.entityMetamodel.isLazy();
    }

    public final Object createProxy(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        return this.getProxyFactory().getProxy(serializable, sessionImplementor);
    }

    public boolean isLifecycleImplementor() {
        return false;
    }

    public boolean isValidatableImplementor() {
        return false;
    }

    protected final EntityMetamodel getEntityMetamodel() {
        return this.entityMetamodel;
    }

    protected final SessionFactoryImplementor getFactory() {
        return this.entityMetamodel.getSessionFactory();
    }

    protected final Instantiator getInstantiator() {
        return this.instantiator;
    }

    protected final ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getEntityMetamodel().getName() + ')';
    }
}

