/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.component;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.EntityModeToTuplizerMapping;
import org.hibernate.tuple.component.ComponentTuplizer;
import org.hibernate.tuple.component.Dom4jComponentTuplizer;
import org.hibernate.tuple.component.DynamicMapComponentTuplizer;
import org.hibernate.tuple.component.PojoComponentTuplizer;
import org.hibernate.util.ReflectHelper;

class ComponentEntityModeToTuplizerMapping
extends EntityModeToTuplizerMapping
implements Serializable {
    private static final Class[] COMPONENT_TUP_CTOR_SIG = new Class[]{Component.class};

    public ComponentEntityModeToTuplizerMapping(Component component) {
        PersistentClass persistentClass = component.getOwner();
        HashMap hashMap = new HashMap();
        if (component.getTuplizerMap() != null) {
            hashMap.putAll(component.getTuplizerMap());
        }
        ComponentTuplizer componentTuplizer = null;
        String string = (String)hashMap.remove(EntityMode.MAP);
        componentTuplizer = string == null ? new DynamicMapComponentTuplizer(component) : this.buildComponentTuplizer(string, component);
        string = (String)hashMap.remove(EntityMode.POJO);
        ComponentTuplizer componentTuplizer2 = null;
        componentTuplizer2 = persistentClass.hasPojoRepresentation() && component.hasPojoRepresentation() ? (string == null ? new PojoComponentTuplizer(component) : this.buildComponentTuplizer(string, component)) : componentTuplizer;
        ComponentTuplizer componentTuplizer3 = null;
        string = (String)hashMap.remove(EntityMode.DOM4J);
        componentTuplizer3 = persistentClass.hasDom4jRepresentation() ? (string == null ? new Dom4jComponentTuplizer(component) : this.buildComponentTuplizer(string, component)) : null;
        if (componentTuplizer2 != null) {
            this.addTuplizer(EntityMode.POJO, componentTuplizer2);
        }
        if (componentTuplizer != null) {
            this.addTuplizer(EntityMode.MAP, componentTuplizer);
        }
        if (componentTuplizer3 != null) {
            this.addTuplizer(EntityMode.DOM4J, componentTuplizer3);
        }
        if (!hashMap.isEmpty()) {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                EntityMode entityMode = (EntityMode)entry.getKey();
                ComponentTuplizer componentTuplizer4 = this.buildComponentTuplizer((String)entry.getValue(), component);
                this.addTuplizer(entityMode, componentTuplizer4);
            }
        }
    }

    private ComponentTuplizer buildComponentTuplizer(String string, Component component) {
        try {
            Class clazz = ReflectHelper.classForName(string);
            return (ComponentTuplizer)clazz.getConstructor(COMPONENT_TUP_CTOR_SIG).newInstance(component);
        }
        catch (Throwable throwable) {
            throw new HibernateException("Could not build tuplizer [" + string + "]", throwable);
        }
    }
}

