/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.InstantiationException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.bytecode.ReflectionOptimizer;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.Instantiator;
import org.hibernate.util.ReflectHelper;

public class PojoInstantiator
implements Instantiator,
Serializable {
    private static final Log log = LogFactory.getLog((Class)PojoInstantiator.class);
    private transient Constructor constructor;
    private final Class mappedClass;
    private final transient ReflectionOptimizer.InstantiationOptimizer optimizer;
    private final boolean embeddedIdentifier;
    private final Class proxyInterface;

    public PojoInstantiator(Component component, ReflectionOptimizer.InstantiationOptimizer instantiationOptimizer) {
        this.mappedClass = component.getComponentClass();
        this.optimizer = instantiationOptimizer;
        this.proxyInterface = null;
        this.embeddedIdentifier = false;
        try {
            this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            log.info((Object)("no default (no-argument) constructor for class: " + this.mappedClass.getName() + " (class must be instantiated by Interceptor)"));
            this.constructor = null;
        }
    }

    public PojoInstantiator(PersistentClass persistentClass, ReflectionOptimizer.InstantiationOptimizer instantiationOptimizer) {
        this.mappedClass = persistentClass.getMappedClass();
        this.proxyInterface = persistentClass.getProxyInterface();
        this.embeddedIdentifier = persistentClass.hasEmbeddedIdentifier();
        this.optimizer = instantiationOptimizer;
        try {
            this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            log.info((Object)("no default (no-argument) constructor for class: " + this.mappedClass.getName() + " (class must be instantiated by Interceptor)"));
            this.constructor = null;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
    }

    public Object instantiate() {
        if (ReflectHelper.isAbstractClass(this.mappedClass)) {
            throw new InstantiationException("Cannot instantiate abstract class or interface: ", this.mappedClass);
        }
        if (this.optimizer != null) {
            return this.optimizer.newInstance();
        }
        if (this.constructor == null) {
            throw new InstantiationException("No default constructor for entity: ", this.mappedClass);
        }
        try {
            return this.constructor.newInstance(null);
        }
        catch (Exception exception) {
            throw new InstantiationException("Could not instantiate entity: ", this.mappedClass, exception);
        }
    }

    public Object instantiate(Serializable serializable) {
        boolean bl = this.embeddedIdentifier && serializable != null && serializable.getClass().equals(this.mappedClass);
        return bl ? serializable : this.instantiate();
    }

    public boolean isInstance(Object object) {
        return this.mappedClass.isInstance(object) || this.proxyInterface != null && this.proxyInterface.isInstance(object);
    }
}

