/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transform;

import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.property.ChainedPropertyAccessor;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.transform.ResultTransformer;

public class AliasToBeanResultTransformer
implements ResultTransformer {
    private final Class resultClass;
    private Setter[] setters;
    private PropertyAccessor propertyAccessor;

    public AliasToBeanResultTransformer(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("resultClass cannot be null");
        }
        this.resultClass = clazz;
        this.propertyAccessor = new ChainedPropertyAccessor(new PropertyAccessor[]{PropertyAccessorFactory.getPropertyAccessor(clazz, null), PropertyAccessorFactory.getPropertyAccessor("field")});
    }

    public Object transformTuple(Object[] objectArray, String[] stringArray) {
        Object t;
        try {
            int n;
            if (this.setters == null) {
                this.setters = new Setter[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    String string = stringArray[n];
                    if (string == null) continue;
                    this.setters[n] = this.propertyAccessor.getSetter(this.resultClass, string);
                }
            }
            t = this.resultClass.newInstance();
            for (n = 0; n < stringArray.length; ++n) {
                if (this.setters[n] == null) continue;
                this.setters[n].set(t, objectArray[n], null);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new HibernateException("Could not instantiate resultclass: " + this.resultClass.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new HibernateException("Could not instantiate resultclass: " + this.resultClass.getName());
        }
        return t;
    }

    public List transformList(List list) {
        return list;
    }
}

