/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.transaction.TransactionManagerLookup;

public class WebSphereTransactionManagerLookup
implements TransactionManagerLookup {
    private static final Log log = LogFactory.getLog((Class)WebSphereTransactionManagerLookup.class);
    private final int wsVersion;
    private final Class tmfClass;

    public WebSphereTransactionManagerLookup() {
        try {
            int n;
            Class<?> clazz;
            try {
                clazz = Class.forName("com.ibm.ws.Transaction.TransactionManagerFactory");
                n = 5;
                log.info((Object)"WebSphere 5.1");
            }
            catch (Exception exception) {
                try {
                    clazz = Class.forName("com.ibm.ejs.jts.jta.TransactionManagerFactory");
                    n = 5;
                    log.info((Object)"WebSphere 5.0");
                }
                catch (Exception exception2) {
                    clazz = Class.forName("com.ibm.ejs.jts.jta.JTSXA");
                    n = 4;
                    log.info((Object)"WebSphere 4");
                }
            }
            this.tmfClass = clazz;
            this.wsVersion = n;
        }
        catch (Exception exception) {
            throw new HibernateException("Could not obtain WebSphere TransactionManagerFactory instance", exception);
        }
    }

    public TransactionManager getTransactionManager(Properties properties) throws HibernateException {
        try {
            return (TransactionManager)this.tmfClass.getMethod("getTransactionManager", null).invoke(null, null);
        }
        catch (Exception exception) {
            throw new HibernateException("Could not obtain WebSphere TransactionManager", exception);
        }
    }

    public String getUserTransactionName() {
        return this.wsVersion == 5 ? "java:comp/UserTransaction" : "jta/usertransaction";
    }
}

