/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.hibernate.HibernateException;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.util.NamingHelper;

public class WebSphereExtendedJTATransactionLookup
implements TransactionManagerLookup {
    public TransactionManager getTransactionManager(Properties properties) throws HibernateException {
        return new TransactionManagerAdapter(properties);
    }

    public String getUserTransactionName() {
        return "java:comp/UserTransaction";
    }

    public static class TransactionManagerAdapter
    implements TransactionManager {
        private final Properties properties;
        private final Class synchronizationCallbackClass;
        private final Method registerSynchronizationMethod;
        private final Method getLocalIdMethod;

        private TransactionManagerAdapter(Properties properties) {
            this.properties = properties;
            try {
                this.synchronizationCallbackClass = Class.forName("com.ibm.websphere.jtaextensions.SynchronizationCallback");
                Class<?> clazz = Class.forName("com.ibm.websphere.jtaextensions.ExtendedJTATransaction");
                this.registerSynchronizationMethod = clazz.getMethod("registerSynchronizationCallbackForCurrentTran", this.synchronizationCallbackClass);
                this.getLocalIdMethod = clazz.getMethod("getLocalId", null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new HibernateException(classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new HibernateException(noSuchMethodException);
            }
        }

        public void begin() throws NotSupportedException, SystemException {
            throw new UnsupportedOperationException();
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            throw new UnsupportedOperationException();
        }

        public int getStatus() throws SystemException {
            throw new UnsupportedOperationException();
        }

        public Transaction getTransaction() throws SystemException {
            return new TransactionAdapter(this.properties);
        }

        public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
            throw new UnsupportedOperationException();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            throw new UnsupportedOperationException();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            throw new UnsupportedOperationException();
        }

        public void setTransactionTimeout(int n) throws SystemException {
            throw new UnsupportedOperationException();
        }

        public Transaction suspend() throws SystemException {
            throw new UnsupportedOperationException();
        }

        public class TransactionAdapter
        implements Transaction {
            private final Object extendedJTATransaction;

            private TransactionAdapter(Properties properties) {
                try {
                    this.extendedJTATransaction = NamingHelper.getInitialContext(properties).lookup("java:comp/websphere/ExtendedJTATransaction");
                }
                catch (NamingException namingException) {
                    throw new HibernateException(namingException);
                }
            }

            public void registerSynchronization(final Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
                InvocationHandler invocationHandler = new InvocationHandler(){

                    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                        if ("afterCompletion".equals(method.getName())) {
                            int n = objectArray[2].equals(Boolean.TRUE) ? 3 : 5;
                            synchronization.afterCompletion(n);
                        } else if ("beforeCompletion".equals(method.getName())) {
                            synchronization.beforeCompletion();
                        } else if ("toString".equals(method.getName())) {
                            return synchronization.toString();
                        }
                        return null;
                    }
                };
                Object object = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{TransactionManagerAdapter.this.synchronizationCallbackClass}, invocationHandler);
                try {
                    TransactionManagerAdapter.this.registerSynchronizationMethod.invoke(this.extendedJTATransaction, object);
                }
                catch (Exception exception) {
                    throw new HibernateException(exception);
                }
            }

            public int hashCode() {
                return this.getLocalId().hashCode();
            }

            public boolean equals(Object object) {
                if (!(object instanceof TransactionAdapter)) {
                    return false;
                }
                TransactionAdapter transactionAdapter = (TransactionAdapter)object;
                return this.getLocalId().equals(transactionAdapter.getLocalId());
            }

            private Object getLocalId() {
                try {
                    return TransactionManagerAdapter.this.getLocalIdMethod.invoke(this.extendedJTATransaction, null);
                }
                catch (Exception exception) {
                    throw new HibernateException(exception);
                }
            }

            public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
                throw new UnsupportedOperationException();
            }

            public boolean delistResource(XAResource xAResource, int n) throws IllegalStateException, SystemException {
                throw new UnsupportedOperationException();
            }

            public boolean enlistResource(XAResource xAResource) throws RollbackException, IllegalStateException, SystemException {
                throw new UnsupportedOperationException();
            }

            public int getStatus() throws SystemException {
                return new Integer(0).equals(this.getLocalId()) ? 6 : 0;
            }

            public void rollback() throws IllegalStateException, SystemException {
                throw new UnsupportedOperationException();
            }

            public void setRollbackOnly() throws IllegalStateException, SystemException {
                throw new UnsupportedOperationException();
            }
        }
    }
}

