/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.util.ReflectHelper;

public final class TransactionManagerLookupFactory {
    private static final Log log = LogFactory.getLog((Class)TransactionManagerLookupFactory.class);

    private TransactionManagerLookupFactory() {
    }

    public static final TransactionManager getTransactionManager(Properties properties) throws HibernateException {
        log.info((Object)"obtaining TransactionManager");
        return TransactionManagerLookupFactory.getTransactionManagerLookup(properties).getTransactionManager(properties);
    }

    public static final TransactionManagerLookup getTransactionManagerLookup(Properties properties) throws HibernateException {
        String string = properties.getProperty("hibernate.transaction.manager_lookup_class");
        if (string == null) {
            log.info((Object)"No TransactionManagerLookup configured (in JTA environment, use of read-write or transactional second-level cache is not recommended)");
            return null;
        }
        log.info((Object)("instantiating TransactionManagerLookup: " + string));
        try {
            TransactionManagerLookup transactionManagerLookup = (TransactionManagerLookup)ReflectHelper.classForName(string).newInstance();
            log.info((Object)"instantiated TransactionManagerLookup");
            return transactionManagerLookup;
        }
        catch (Exception exception) {
            log.error((Object)"Could not instantiate TransactionManagerLookup", (Throwable)exception);
            throw new HibernateException("Could not instantiate TransactionManagerLookup");
        }
    }
}

