/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.transaction.JDBCTransactionFactory;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.ReflectHelper;

public final class TransactionFactoryFactory {
    private static final Log log = LogFactory.getLog((Class)TransactionFactoryFactory.class);

    public static TransactionFactory buildTransactionFactory(Properties properties) throws HibernateException {
        TransactionFactory transactionFactory;
        String string = properties.getProperty("hibernate.transaction.factory_class");
        if (string == null) {
            log.info((Object)"Using default transaction strategy (direct JDBC transactions)");
            return new JDBCTransactionFactory();
        }
        log.info((Object)("Transaction strategy: " + string));
        try {
            transactionFactory = (TransactionFactory)ReflectHelper.classForName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error((Object)"TransactionFactory class not found", (Throwable)classNotFoundException);
            throw new HibernateException("TransactionFactory class not found: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.error((Object)"Failed to instantiate TransactionFactory", (Throwable)illegalAccessException);
            throw new HibernateException("Failed to instantiate TransactionFactory: " + illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            log.error((Object)"Failed to instantiate TransactionFactory", (Throwable)instantiationException);
            throw new HibernateException("Failed to instantiate TransactionFactory: " + instantiationException);
        }
        transactionFactory.configure(properties);
        return transactionFactory;
    }

    private TransactionFactoryFactory() {
    }
}

